#ifndef _HACKBONE_INTERFACE
#define _HACKBONE_INTERFACE

/*************************************************************************/
/** @addtogroup interfaces */
/** @{ */
/** @defgroup hackbone hackbone

  Hacked backbone.

@{
*/

/**Maximum number of robots */
#define PLAYER_HACKBONE_MAX_HOSTS 401
#define PLAYER_HACKBONE_MAX_NAMELENGTH 20

/** @brief A single detected feature

The feature data packet contains a list of these. */
typedef struct player_hackbone_item {
  char host[PLAYER_HACKBONE_MAX_NAMELENGTH];
  char via[PLAYER_HACKBONE_MAX_NAMELENGTH];
  int hops;
} __PACKED__ player_hackbone_host_t;

/** @brief Array of features
 *
 * The feature data packet (all features). */
typedef struct player_feature2d_data {
    uint16_t count;
      player_hackbone_host_t hosts[PLAYER_HACKBONE_MAX_HOSTS];
} __PACKED__ player_hackbone_data_t;

/** @} */

/** @} */
#endif
