/***************************************************************************
 * Desc: Tests for the position device
 * Author: Andrew Howard
 * Date: 23 May 2002
 # CVS: $Id: test_position.c,v 1.12 2004/11/13 00:02:38 inspectorg Exp $
 **************************************************************************/

#include "test.h"
#include "playerc.h"


// Basic test for position device.
int test_position(playerc_client_t *client, int index)
{
  int t;
  void *rdevice;
  playerc_position_t *device;

  printf("device [position] index [%d]\n", index);

  device = playerc_position_create(client, index);

  TEST("subscribing (read/write)");
  if (playerc_position_subscribe(device, PLAYER_ALL_MODE) < 0)
  {
    FAIL();
    return -1;
  }
  PASS();

  TEST("getting geometry");
  if (playerc_position_get_geom(device) == 0)
    PASS();
  else
    FAIL();
  printf("position geom: [%6.3f %6.3f %6.3f] [%6.3f %6.3f]\n",
         device->pose[0], device->pose[1], device->pose[2], device->size[0], device->size[1]);

  TEST("enabling motors");
  if (playerc_position_enable(device, 1) == 0)
    PASS();
  else
    FAIL();
  
  for (t = 0; t < 30; t++)
  {
    TEST1("reading data (attempt %d)", t);

    do
      rdevice = playerc_client_read(client);
    while (rdevice == client);

    if (rdevice == device)
    {
      PASS();
      printf("position: [%14.3f] [%6.3f] [%6.3f] [%6.3f] [%d]\n",
             device->info.datatime, device->px, device->py, device->pa, device->stall);
    }
    else
    {
      //printf("error: %s", playerc_error_str());
      FAIL();
      break;
    }

    TEST1("writing data (attempt %d)", t);
    if (playerc_position_set_cmd_vel(device, 0.10, 0.0, 0.2, 1) != 0)
    {
      FAIL();
      break;
    }
    PASS();
  }

  TEST1("writing data (attempt %d)", t);
  if (playerc_position_set_cmd_vel(device, 0.0, 0.0, 0.0, 1) != 0)
    FAIL();
  else
    PASS();

  TEST("disabling motors");
  if (playerc_position_enable(device, 0) == 0)
    PASS();
  else
    FAIL();
  
  TEST("unsubscribing");
  if (playerc_position_unsubscribe(device) != 0)
    FAIL();
  else
    PASS();
  
  playerc_position_destroy(device);
  
  return 0;
}

