/*
 * $Id: test_misc.cc,v 1.3 2003/04/27 04:45:40 gerkey Exp $
 *
 * a test for the C++ SonarProxy
 */

#include "playerclient.h"
#include "test.h"
#include <unistd.h>

int
test_misc(PlayerClient* client, int index)
{
  unsigned char access;
  MiscProxy mp(client,index,'c');

  printf("device [misc] index [%d]\n", index);

  TEST("subscribing (read)");
  if((mp.ChangeAccess(PLAYER_READ_MODE,&access) < 0) ||
     (access != PLAYER_READ_MODE))
  {
    FAIL();
    return -1;
  }
  PASS();

  // wait for P2OS to start up
  for(int i=0; i < 20; i++)
    client->Read();

  for(int t = 0; t < 3; t++)
  {
    TEST1("reading data (attempt %d)", t);

    if(client->Read() < 0)
    {
      FAIL();
      return(-1);
    }

    PASS();

    mp.Print();
  }

  TEST("unsubscribing");
  if((mp.ChangeAccess(PLAYER_CLOSE_MODE,&access) < 0) ||
     (access != PLAYER_CLOSE_MODE))
  {
    FAIL();
    return -1;
  }

  PASS();

  return(0);
}

