/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2004, 2005 Richard Vaughan
 *                      
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * Desc: A plugin driver for Player that gives access to Stage devices.
 * Author: Richard Vaughan
 * Date: 10 December 2004
 * CVS: $Id: p_blobfinder.cc,v 1.1 2005/07/15 03:41:37 rtv Exp $
 */


#include "p_driver.h"
#include "hackbone_interface.h"

extern "C" {
int hackbone_init( stg_model_t* mod ); 
}

InterfaceHackbone::InterfaceHackbone( player_device_id_t id, 
				StgDriver* driver,
				ConfigFile* cf,
				int section )
  : InterfaceModel( id, driver, cf, section, hackbone_init )
{
  this->data_len = sizeof(player_hackbone_data_t);
  this->cmd_len = 0;
}


void InterfaceHackbone::Publish( void )
{
  player_hackbone_data_t pdata;
  memset( &pdata, 0, sizeof(player_hackbone_data_t));
  
  GArray *peers = (GArray *) stg_model_get_property_fixed(this->mod, "hackbone_data", sizeof(GArray));

  if( peers != NULL ) {
      //printf("Stage fill hackbone %d\n", peers->len);
      pdata.count = htons((uint16_t)peers->len);
      for( int i=0; i < (int)peers->len; i++ ) {
        stg_hackbone_t x = g_array_index(peers, stg_hackbone_t, i);
        snprintf(pdata.hosts[i].host, PLAYER_HACKBONE_MAX_NAMELENGTH, "%s", (x.model)->token);
        snprintf(pdata.hosts[i].via, PLAYER_HACKBONE_MAX_NAMELENGTH, "%s", (x.firsthop)->token);
        pdata.hosts[i].hops = x.hops;
      }
    }

  // publish this data
  this->driver->PutData( this->id, &pdata, sizeof(pdata), NULL);
}

void InterfaceHackbone::Configure( void* client, void* buffer, size_t len )
{
  printf("got hackbone config request, ignoring\n");
  
  if (this->driver->PutReply( this->id, client, PLAYER_MSGTYPE_RESP_NACK, NULL, 0, NULL) != 0)
    DRIVER_ERROR("PutReply() failed");  
}

