/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2004, 2005 Richard Vaughan
 *                      
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * Desc: A plugin driver for Player that gives access to Stage devices.
 * Author: Richard Vaughan
 * Date: 10 December 2004
 * CVS: $Id: p_blobfinder.cc,v 1.1 2005/07/15 03:41:37 rtv Exp $
 */


#include "p_driver.h"

extern "C" {
int rangecom_init( stg_model_t* mod ); 
}

InterfaceWifi::InterfaceWifi( player_devaddr_t id, 
				StgDriver* driver,
				ConfigFile* cf,
				int section )
  : InterfaceModel( id, driver, cf, section, rangecom_init )
{
  // ?? Nothing?
}


void InterfaceWifi::Publish( void )
{
  player_wifi_data_t pdata;
  memset( &pdata, 0, sizeof(pdata) );
  
  size_t datalen = mod->data_len;
  stg_rangecom_t *peers = (stg_rangecom_t*) mod->data;

  if( datalen > 0 ) {
      size_t fcount = datalen / sizeof(stg_rangecom_t);
      assert( fcount > 0 );
      
      pdata.throughput = 0;
      pdata.bitrate = 0;
      pdata.mode = PLAYER_WIFI_MODE_UNKNOWN;
      pdata.qual_type = PLAYER_WIFI_QUAL_UNKNOWN;
      pdata.maxqual = 0;
      pdata.maxlevel = 0;
      pdata.maxnoise = 0;
      snprintf(pdata.ap, 32, "stagedriver faked");

      pdata.links_count = (uint32_t)fcount;
      for( int i=0; i<(int)fcount; i++ ) {
      
        // XXX: This is totally NOT RIGHT.  We need some other way of modeling this in 
        //  stage without using wifi?
        pdata.links[i].mac_count = 32; // WTH is this for?
        snprintf((char *)pdata.links[i].mac, 32, "%s", peers[i].mac);
        pdata.links[i].ip_count = 32; // WTH is this for?
        snprintf((char *)pdata.links[i].ip, 32, "%s", peers[i].ip);
        pdata.links[i].essid_count = 32; // WTH is this for?
        snprintf((char *)pdata.links[i].essid, 32, "%s", peers[i].essid);

        pdata.links[i].mode = PLAYER_WIFI_MODE_UNKNOWN;
        pdata.links[i].freq = 0;
        pdata.links[i].encrypt = 0;
        pdata.links[i].qual = 0;
        pdata.links[i].level = 0; 
        pdata.links[i].noise = 0;

      }
    }

  // publish this data
  this->driver->Publish( this->addr, NULL, 
      PLAYER_MSGTYPE_DATA, 
      PLAYER_WIFI_DATA_STATE, 
      &pdata, sizeof(pdata), NULL);
}


int InterfaceWifi::ProcessMessage(MessageQueue* resp_queue, 
    player_msghdr_t* hdr, 
    void* data )
{
  PRINT_WARN2( "stage rangecom doesn't support message %d:%d.", hdr->type, hdr->subtype); 
  return (-1); 
}


