/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2004, 2005 Richard Vaughan
 *                      
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * Desc: A plugin driver for Player that gives access to Stage devices.
 * Author: Richard Vaughan
 * Date: 10 December 2004
 * CVS: $Id: p_blobfinder.cc,v 1.1 2005/07/15 03:41:37 rtv Exp $
 */


#include "p_driver.h"

extern "C" {
int gps_init( stg_model_t* mod );
}

InterfaceGps::InterfaceGps( player_devaddr_t addr, 
				StgDriver* driver,
				ConfigFile* cf,
				int section )
  : InterfaceModel( addr, driver, cf, section, gps_init )
{
  // Nothing here?
}


void InterfaceGps::Publish( void )
{
  stg_gps_t *sdata = (stg_gps_t*) mod->data; 
  if (sdata != NULL) { 
    player_gps_data_t pdata;
    memset(&pdata, 0, sizeof(pdata));
  
    pdata.latitude = (int32_t)(sdata->latitude * 1e7);
    pdata.longitude = (int32_t)(sdata->longitude * 1e7);
    pdata.time_sec = (uint32_t)sdata->sec;
    pdata.time_usec = (uint32_t)sdata->usec;
    this->driver->Publish( this->addr, NULL,
        PLAYER_MSGTYPE_DATA, 
        PLAYER_GPS_DATA_STATE,
        (void*)&pdata, sizeof(pdata), NULL);
  }
}

int InterfaceGps::ProcessMessage(MessageQueue* resp_queue, 
    player_msghdr_t* hdr, 
    void* data )
{
  PRINT_WARN2( "stage gps doesn't support message %d:%d.", hdr->type, hdr->subtype); 
  return (-1); 
}
