/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2004, 2005 Richard Vaughan
 *                      
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * Desc: A plugin driver for Player that gives access to Stage devices.
 * Author: Richard Vaughan
 * Date: 10 December 2004
 * CVS: $Id: p_blobfinder.cc,v 1.1 2005/07/15 03:41:37 rtv Exp $
 */


#include "p_driver.h"

extern "C" {
int rangecom_init( stg_model_t* mod ); 
}

InterfaceWifi::InterfaceWifi( player_device_id_t id, 
				StgDriver* driver,
				ConfigFile* cf,
				int section )
  : InterfaceModel( id, driver, cf, section, rangecom_init )
{
  this->data_len = sizeof(player_wifi_data_t);
  this->cmd_len = 0;
}


void InterfaceWifi::Publish( void )
{
  player_wifi_data_t pdata;
  memset( &pdata, 0, sizeof(pdata) );
  
  size_t datalen = 0;
  stg_rangecom_t *peers = (stg_rangecom_t*)
    stg_model_get_property(this->mod, "rangecom_data", &datalen); 

  if( datalen > 0 ) {
      size_t fcount = datalen / sizeof(stg_rangecom_t);
      assert( fcount > 0 );
      
      pdata.link_count = htons((uint16_t)fcount);
      pdata.throughput = htons(0);
      pdata.bitrate = htonl(0);
      pdata.mode = PLAYER_WIFI_MODE_UNKNOWN;
      pdata.qual_type = PLAYER_WIFI_QUAL_UNKNOWN;
      pdata.maxqual = htons(0);
      pdata.maxlevel = htons(0);
      pdata.maxnoise = htons(0);
      snprintf(pdata.ap, 32, "stagedriver faked");

      for( int i=0; i<(int)fcount; i++ ) {
      
        // XXX: This is totally NOT RIGHT.  We need some other way of modeling this in 
        //  stage without using wifi?
  
        snprintf(pdata.links[i].mac, 32, "%s", peers[i].name);
        snprintf(pdata.links[i].ip, 32, "0.0.0.%d", i);
        snprintf(pdata.links[i].essid, 32, "%s", peers[i].name);

        pdata.links[i].mode = PLAYER_WIFI_MODE_UNKNOWN;
        pdata.links[i].freq = htons(0);
        pdata.links[i].encrypt = 0;
        pdata.links[i].qual = htons(0);
        pdata.links[i].level = htons(0);
        pdata.links[i].noise = htons(0);

      }
    }

  // publish this data
  this->driver->PutData( this->id, &pdata, sizeof(pdata), NULL);
}

void InterfaceWifi::Configure( void* client, void* buffer, size_t len )
{
  printf("got wifi config request, ignoring\n");
  
  if (this->driver->PutReply( this->id, client, PLAYER_MSGTYPE_RESP_NACK, NULL, 0, NULL) != 0)
    DRIVER_ERROR("PutReply() failed");  
}

