<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>libstage Reference Manual</title>
    <filename>index</filename>
  </compound>
  <compound kind="file">
    <name>help.txt</name>
    <path>/home/jamuraa/sources/stage-arch/docsrc/</path>
    <filename>help_8txt</filename>
  </compound>
  <compound kind="file">
    <name>libstage.txt</name>
    <path>/home/jamuraa/sources/stage-arch/docsrc/</path>
    <filename>libstage_8txt</filename>
  </compound>
  <compound kind="file">
    <name>stage.h</name>
    <path>/home/jamuraa/sources/stage-arch/src/</path>
    <filename>stage_8h</filename>
    <class kind="struct">stg_size_t</class>
    <class kind="struct">stg_pose_t</class>
    <class kind="struct">stg_geom_t</class>
    <class kind="struct">stg_energy_data_t</class>
    <class kind="struct">stg_energy_config_t</class>
    <class kind="struct">stg_guifeatures_t</class>
    <class kind="struct">stg_rotrect_t</class>
    <class kind="struct">stg_point_t</class>
    <class kind="struct">stg_polygon_t</class>
    <class kind="struct">stg_cbarg_t</class>
    <class kind="struct">stg_property</class>
    <class kind="struct">stg_blobfinder_config_t</class>
    <class kind="struct">stg_blobfinder_blob_t</class>
    <class kind="struct">stg_laser_sample_t</class>
    <class kind="struct">stg_laser_config_t</class>
    <class kind="struct">stg_gripper_config_t</class>
    <class kind="struct">stg_gripper_cmd_t</class>
    <class kind="struct">stg_gripper_data_t</class>
    <class kind="struct">stg_fiducial_config_t</class>
    <class kind="struct">stg_fiducial_t</class>
    <class kind="struct">stg_rangecom_config_t</class>
    <class kind="struct">stg_rangecom_t</class>
    <class kind="struct">stg_gps_config_t</class>
    <class kind="struct">stg_gps_t</class>
    <class kind="struct">stg_compass_config_t</class>
    <class kind="struct">stg_compass_t</class>
    <class kind="struct">stg_bounds_t</class>
    <class kind="struct">stg_fov_t</class>
    <class kind="struct">stg_ranger_config_t</class>
    <class kind="struct">stg_ranger_sample_t</class>
    <class kind="struct">stg_position_cmd_t</class>
    <class kind="struct">stg_position_data_t</class>
    <member kind="define">
      <type>#define</type>
      <name>FiducialNone</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga56</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RangecomNone</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga57</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RangecomImpede</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga58</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RangecomPoint</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga59</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_MOVE_TRANS</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga60</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_MOVE_ROT</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga61</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_MOVE_SCALE</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga62</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_PROPNAME_MAX</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga63</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_BLOB_CHANNELS_MAX</name>
      <anchorfile>group__stg__model__blobfinder.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_POSITION_CONTROL_DEFAULT</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_POSITION_LOCALIZATION_DEFAULT</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_POSITION_DRIVE_DEFAULT</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TRUE</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FALSE</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>MILLION</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>BILLION</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>M_PI</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga10</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TWOPI</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga11</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RTOD</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga12</anchor>
      <arglist>(r)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>DTOR</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga13</anchor>
      <arglist>(d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>NORMALIZE</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga14</anchor>
      <arglist>(z)</arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_id_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_meters_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_radians_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned long</type>
      <name>stg_msec_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_kg_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_joules_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_watts_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_bool_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_friction_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>uint32_t</type>
      <name>stg_color_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_obstacle_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga10</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_blob_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga11</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_fiducial_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga12</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_rangecom_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga13</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_ranger_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga14</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>stg_pose_t</type>
      <name>stg_velocity_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga15</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_movemask_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga16</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_stg_model</type>
      <name>stg_model_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga17</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_stg_world</type>
      <name>stg_world_t</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int(*</type>
      <name>stg_property_callback_t</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>)(stg_model_t *mod, char *name, void *data, size_t len, void *userdata)</arglist>
    </member>
    <member kind="typedef">
      <type>void(*</type>
      <name>stg_property_storage_func_t</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>)(struct stg_property *prop, void *data, size_t len)</arglist>
    </member>
    <member kind="typedef">
      <type>stg_property</type>
      <name>stg_property_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga18</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int(*</type>
      <name>stg_model_initializer_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga19</anchor>
      <arglist>)(stg_model_t *)</arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_position_stall_t</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_gripper_return_t</name>
      <anchor>ga64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIP_NO</name>
      <anchor>gga64a45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIP_YES</name>
      <anchor>gga64a46</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_laser_return_t</name>
      <anchor>ga65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LaserTransparent</name>
      <anchor>gga65a47</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LaserVisible</name>
      <anchor>gga65a48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LaserBright</name>
      <anchor>gga65a49</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_gripper_paddle_state_t</name>
      <anchor>ga2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_PADDLE_OPEN</name>
      <anchor>gga2a50</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_PADDLE_CLOSED</name>
      <anchor>gga2a51</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_PADDLE_OPENING</name>
      <anchor>gga2a52</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_PADDLE_CLOSING</name>
      <anchor>gga2a53</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_gripper_lift_state_t</name>
      <anchor>ga3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_LIFT_DOWN</name>
      <anchor>gga3a54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_LIFT_UP</name>
      <anchor>gga3a55</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_LIFT_UPPING</name>
      <anchor>gga3a56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_LIFT_DOWNING</name>
      <anchor>gga3a57</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_gripper_cmd_type_t</name>
      <anchor>ga4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_NOP</name>
      <anchor>gga4a58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_OPEN</name>
      <anchor>gga4a59</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_CLOSE</name>
      <anchor>gga4a60</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_UP</name>
      <anchor>gga4a61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_DOWN</name>
      <anchor>gga4a62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_position_control_mode_t</name>
      <anchor>ga6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_CONTROL_VELOCITY</name>
      <anchor>gga6a63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_CONTROL_POSITION</name>
      <anchor>gga6a64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_position_localization_mode_t</name>
      <anchor>ga7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_LOCALIZATION_GPS</name>
      <anchor>gga7a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_LOCALIZATION_ODOM</name>
      <anchor>gga7a66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_position_drive_mode_t</name>
      <anchor>ga8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_DRIVE_DIFFERENTIAL</name>
      <anchor>gga8a67</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_DRIVE_OMNI</name>
      <anchor>gga8a68</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>stg_msec_t</type>
      <name>stg_timenow</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_init</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(int argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>stg_get_version_string</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_quit_test</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_quit_request</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_err</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist>(const char *err)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_pose_sum</name>
      <anchorfile>group__util.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_pose_t *result, stg_pose_t *p1, stg_pose_t *p2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_normalize_rects</name>
      <anchorfile>group__rotrect.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_rotrect_t *rects, int num)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_load_image</name>
      <anchorfile>group__rotrect.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(const char *filename, stg_rotrect_t **rects, int *rect_count, int *widthp, int *heightp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_print_geom</name>
      <anchorfile>group__util.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_geom_t *geom)</arglist>
    </member>
    <member kind="function">
      <type>stg_color_t</type>
      <name>stg_lookup_color</name>
      <anchorfile>group__util.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>stg_point_t *</type>
      <name>stg_points_create</name>
      <anchorfile>group__stg__point.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(size_t count)</arglist>
    </member>
    <member kind="function">
      <type>stg_point_t *</type>
      <name>stg_point_create</name>
      <anchorfile>group__stg__point.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_points_destroy</name>
      <anchorfile>group__stg__point.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(stg_point_t *pts)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_point_destroy</name>
      <anchorfile>group__stg__point.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist>(stg_point_t *pt)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_polygons_create</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(int count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygons_destroy</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_polygon_t *p, size_t count)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_polygon_create</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_unit_polygon_create</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygon_destroy</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist>(stg_polygon_t *p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygon_set_points</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist>(stg_polygon_t *poly, stg_point_t *pts, size_t count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygon_append_points</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga6</anchor>
      <arglist>(stg_polygon_t *poly, stg_point_t *pts, size_t count)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_rects_to_polygons</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga7</anchor>
      <arglist>(stg_rotrect_t *rects, size_t count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_normalize_polygons</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga8</anchor>
      <arglist>(stg_polygon_t *polys, int num, double width, double height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygon_print</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga9</anchor>
      <arglist>(stg_polygon_t *poly)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygons_print</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga10</anchor>
      <arglist>(stg_polygon_t *polys, unsigned int count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_get_default_pose</name>
      <anchorfile>group__defaults.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_pose_t *pose)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_get_default_geom</name>
      <anchorfile>group__defaults.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_geom_t *geom)</arglist>
    </member>
    <member kind="function">
      <type>stg_world_t *</type>
      <name>stg_world_create</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist>(stg_id_t id, const char *token, int sim_interval, int real_interval, double ppm, double width, double height)</arglist>
    </member>
    <member kind="function">
      <type>stg_world_t *</type>
      <name>stg_world_create_from_file</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist>(const char *worldfile_path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_destroy</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist>(stg_world_t *world)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_stop</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga6</anchor>
      <arglist>(stg_world_t *world)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_start</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga7</anchor>
      <arglist>(stg_world_t *world)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_world_update</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga8</anchor>
      <arglist>(stg_world_t *world, int sleepflag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_load</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga9</anchor>
      <arglist>(stg_world_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_save</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga10</anchor>
      <arglist>(stg_world_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_print</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga11</anchor>
      <arglist>(stg_world_t *world)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_set_interval_real</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga12</anchor>
      <arglist>(stg_world_t *world, unsigned int val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_set_interval_sim</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga13</anchor>
      <arglist>(stg_world_t *world, unsigned int val)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_world_get_model</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga14</anchor>
      <arglist>(stg_world_t *world, stg_id_t mid)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_world_model_name_lookup</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga15</anchor>
      <arglist>(stg_world_t *world, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_add_property_callback</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga16</anchor>
      <arglist>(stg_world_t *world, char *propname, stg_property_callback_t callback, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_remove_property_callback</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga17</anchor>
      <arglist>(stg_world_t *world, char *propname, stg_property_callback_t callback)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_add_property_toggles</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga18</anchor>
      <arglist>(stg_model_t *mod, const char *propname, stg_property_callback_t callback_on, void *arg_on, stg_property_callback_t callback_off, void *arg_off, const char *label, int enabled)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_fig_clear_cb</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga19</anchor>
      <arglist>(stg_model_t *mod, void *data, size_t len, void *userp)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_model_create</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga20</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token, stg_model_initializer_t initializer)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_destroy</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga21</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_get_global_pose</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga22</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *pose)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_get_global_velocity</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga23</anchor>
      <arglist>(stg_model_t *mod, stg_velocity_t *gvel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_subscribe</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga24</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_unsubscribe</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga25</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_load</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga26</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_save</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga27</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_set_global_pose</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga28</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *gpose)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_set_velocity</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga29</anchor>
      <arglist>(stg_model_t *mod, stg_velocity_t *vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_lock</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga30</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_unlock</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga31</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_set_parent</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga32</anchor>
      <arglist>(stg_model_t *mod, stg_model_t *newparent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_get_geom</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga33</anchor>
      <arglist>(stg_model_t *mod, stg_geom_t *dest)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_get_velocity</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga34</anchor>
      <arglist>(stg_model_t *mod, stg_velocity_t *dest)</arglist>
    </member>
    <member kind="function">
      <type>stg_property_t *</type>
      <name>stg_model_set_property</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga35</anchor>
      <arglist>(stg_model_t *mod, const char *prop, void *data, size_t len)</arglist>
    </member>
    <member kind="function">
      <type>stg_property_t *</type>
      <name>stg_model_set_property_ex</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga36</anchor>
      <arglist>(stg_model_t *mod, const char *prop, void *data, size_t len, stg_property_storage_func_t func)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>stg_model_get_property</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga37</anchor>
      <arglist>(stg_model_t *mod, const char *prop, size_t *len)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>stg_model_get_property_fixed</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga38</anchor>
      <arglist>(stg_model_t *mod, const char *name, size_t size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_property_refresh</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga39</anchor>
      <arglist>(stg_model_t *mod, const char *propname)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_model_get_polygons</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga40</anchor>
      <arglist>(stg_model_t *mod, size_t *poly_count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_set_polygons</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga41</anchor>
      <arglist>(stg_model_t *mod, stg_polygon_t *polys, size_t poly_count)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_add_property_callback</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga42</anchor>
      <arglist>(stg_model_t *mod, const char *prop, stg_property_callback_t, void *user)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_remove_property_callback</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga43</anchor>
      <arglist>(stg_model_t *mod, const char *prop, stg_property_callback_t)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_remove_property_callbacks</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga44</anchor>
      <arglist>(stg_model_t *mod, const char *prop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_print</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga45</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_is_antecedent</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga46</anchor>
      <arglist>(stg_model_t *mod, stg_model_t *testmod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_is_descendent</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga47</anchor>
      <arglist>(stg_model_t *mod, stg_model_t *testmod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_is_related</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga48</anchor>
      <arglist>(stg_model_t *mod1, stg_model_t *mod2)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_model_root</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga49</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_tree_to_ptr_array</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga50</anchor>
      <arglist>(stg_model_t *root, GPtrArray *array)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_startup</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga51</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_shutdown</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga52</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_update</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga53</anchor>
      <arglist>(stg_model_t *model)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_global_to_local</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga54</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *pose)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_local_to_global</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga55</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *pose)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_blobfinder_create</name>
      <anchorfile>group__stg__model__blobfinder.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_print_laser_config</name>
      <anchorfile>group__stg__model__laser.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_laser_config_t *slc)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_laser_create</name>
      <anchorfile>group__stg__model__laser.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>stg_model_get_data_laser</name>
      <anchorfile>group__stg__model__laser.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(stg_model_t *mod, stg_laser_sample_t *data, size_t max_samples)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_print_gripper_config</name>
      <anchorfile>group__stg__model__gripper.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_gripper_config_t *slc)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_gripper_create</name>
      <anchorfile>group__stg__model__gripper.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_fiducial_create</name>
      <anchorfile>group__stg__model__fiducial.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_rangecom_create</name>
      <anchorfile>group__stg__model__rangecom.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_gps_create</name>
      <anchorfile>group__stg__model__gps.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_ranger_create</name>
      <anchorfile>group__stg__model__ranger.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_position_create</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_position_set_odom</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *odom)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_blobfinder_blob_t</name>
    <filename>structstg__blobfinder__blob__t.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>channel</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_color_t</type>
      <name>color</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>xpos</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>ypos</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>left</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>top</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>right</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>bottom</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>area</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>range</name>
      <anchorfile>structstg__blobfinder__blob__t.html</anchorfile>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_blobfinder_config_t</name>
    <filename>structstg__blobfinder__config__t.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>channel_count</name>
      <anchorfile>structstg__blobfinder__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_color_t</type>
      <name>channels</name>
      <anchorfile>structstg__blobfinder__config__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist>[STG_BLOB_CHANNELS_MAX]</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>scan_width</name>
      <anchorfile>structstg__blobfinder__config__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>scan_height</name>
      <anchorfile>structstg__blobfinder__config__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>range_max</name>
      <anchorfile>structstg__blobfinder__config__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>pan</name>
      <anchorfile>structstg__blobfinder__config__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>tilt</name>
      <anchorfile>structstg__blobfinder__config__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>zoom</name>
      <anchorfile>structstg__blobfinder__config__t.html</anchorfile>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_bounds_t</name>
    <filename>structstg__bounds__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>min</name>
      <anchorfile>structstg__bounds__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>max</name>
      <anchorfile>structstg__bounds__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_cbarg_t</name>
    <filename>structstg__cbarg__t.html</filename>
    <member kind="variable">
      <type>stg_property_callback_t</type>
      <name>callback</name>
      <anchorfile>structstg__cbarg__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>arg</name>
      <anchorfile>structstg__cbarg__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_compass_config_t</name>
    <filename>structstg__compass__config__t.html</filename>
    <member kind="variable">
      <type>double</type>
      <name>north</name>
      <anchorfile>structstg__compass__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_compass_t</name>
    <filename>structstg__compass__t.html</filename>
    <member kind="variable">
      <type>double</type>
      <name>to_north</name>
      <anchorfile>structstg__compass__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_energy_config_t</name>
    <filename>structstg__energy__config__t.html</filename>
    <member kind="variable">
      <type>stg_joules_t</type>
      <name>capacity</name>
      <anchorfile>structstg__energy__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_watts_t</type>
      <name>give</name>
      <anchorfile>structstg__energy__config__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_watts_t</type>
      <name>take</name>
      <anchorfile>structstg__energy__config__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>probe_range</name>
      <anchorfile>structstg__energy__config__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_energy_data_t</name>
    <filename>structstg__energy__data__t.html</filename>
    <member kind="variable">
      <type>stg_joules_t</type>
      <name>stored</name>
      <anchorfile>structstg__energy__data__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_joules_t</type>
      <name>capacity</name>
      <anchorfile>structstg__energy__data__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_joules_t</type>
      <name>input_joules</name>
      <anchorfile>structstg__energy__data__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_joules_t</type>
      <name>output_joules</name>
      <anchorfile>structstg__energy__data__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_watts_t</type>
      <name>input_watts</name>
      <anchorfile>structstg__energy__data__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_watts_t</type>
      <name>output_watts</name>
      <anchorfile>structstg__energy__data__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>charging</name>
      <anchorfile>structstg__energy__data__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>range</name>
      <anchorfile>structstg__energy__data__t.html</anchorfile>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_fiducial_config_t</name>
    <filename>structstg__fiducial__config__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>max_range_anon</name>
      <anchorfile>structstg__fiducial__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>max_range_id</name>
      <anchorfile>structstg__fiducial__config__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>min_range</name>
      <anchorfile>structstg__fiducial__config__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>fov</name>
      <anchorfile>structstg__fiducial__config__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>heading</name>
      <anchorfile>structstg__fiducial__config__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_fiducial_t</name>
    <filename>structstg__fiducial__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>range</name>
      <anchorfile>structstg__fiducial__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>bearing</name>
      <anchorfile>structstg__fiducial__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_pose_t</type>
      <name>geom</name>
      <anchorfile>structstg__fiducial__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>id</name>
      <anchorfile>structstg__fiducial__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_fov_t</name>
    <filename>structstg__fov__t.html</filename>
    <member kind="variable">
      <type>stg_bounds_t</type>
      <name>range</name>
      <anchorfile>structstg__fov__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>angle</name>
      <anchorfile>structstg__fov__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_geom_t</name>
    <filename>structstg__geom__t.html</filename>
    <member kind="variable">
      <type>stg_pose_t</type>
      <name>pose</name>
      <anchorfile>structstg__geom__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_size_t</type>
      <name>size</name>
      <anchorfile>structstg__geom__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_gps_config_t</name>
    <filename>structstg__gps__config__t.html</filename>
    <member kind="variable">
      <type>double</type>
      <name>lat_base</name>
      <anchorfile>structstg__gps__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>lon_base</name>
      <anchorfile>structstg__gps__config__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_gps_t</name>
    <filename>structstg__gps__t.html</filename>
    <member kind="variable">
      <type>double</type>
      <name>latitude</name>
      <anchorfile>structstg__gps__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>longitude</name>
      <anchorfile>structstg__gps__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>sec</name>
      <anchorfile>structstg__gps__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>usec</name>
      <anchorfile>structstg__gps__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_gripper_cmd_t</name>
    <filename>structstg__gripper__cmd__t.html</filename>
    <member kind="variable">
      <type>stg_gripper_cmd_type_t</type>
      <name>cmd</name>
      <anchorfile>structstg__gripper__cmd__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>arg</name>
      <anchorfile>structstg__gripper__cmd__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_gripper_config_t</name>
    <filename>structstg__gripper__config__t.html</filename>
    <member kind="variable">
      <type>stg_size_t</type>
      <name>paddle_size</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_gripper_paddle_state_t</type>
      <name>paddles</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_gripper_lift_state_t</type>
      <name>lift</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>paddle_position</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>lift_position</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>inner_break_beam_inset</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>outer_break_beam_inset</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>paddles_stalled</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>GSList *</type>
      <name>grip_stack</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>grip_stack_size</name>
      <anchorfile>structstg__gripper__config__t.html</anchorfile>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_gripper_data_t</name>
    <filename>structstg__gripper__data__t.html</filename>
    <member kind="variable">
      <type>stg_gripper_paddle_state_t</type>
      <name>paddles</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_gripper_lift_state_t</type>
      <name>lift</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>paddle_position</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>lift_position</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>inner_break_beam</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>outer_break_beam</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>left_paddle_contact</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist>[3]</arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>right_paddle_contact</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o7</anchor>
      <arglist>[3]</arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>paddles_stalled</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>stack_count</name>
      <anchorfile>structstg__gripper__data__t.html</anchorfile>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_guifeatures_t</name>
    <filename>structstg__guifeatures__t.html</filename>
    <member kind="variable">
      <type>uint8_t</type>
      <name>show_data</name>
      <anchorfile>structstg__guifeatures__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint8_t</type>
      <name>show_cfg</name>
      <anchorfile>structstg__guifeatures__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint8_t</type>
      <name>show_cmd</name>
      <anchorfile>structstg__guifeatures__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint8_t</type>
      <name>nose</name>
      <anchorfile>structstg__guifeatures__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint8_t</type>
      <name>grid</name>
      <anchorfile>structstg__guifeatures__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint8_t</type>
      <name>outline</name>
      <anchorfile>structstg__guifeatures__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_movemask_t</type>
      <name>movemask</name>
      <anchorfile>structstg__guifeatures__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_laser_config_t</name>
    <filename>structstg__laser__config__t.html</filename>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>fov</name>
      <anchorfile>structstg__laser__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>range_max</name>
      <anchorfile>structstg__laser__config__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>range_min</name>
      <anchorfile>structstg__laser__config__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>samples</name>
      <anchorfile>structstg__laser__config__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_laser_sample_t</name>
    <filename>structstg__laser__sample__t.html</filename>
    <member kind="variable">
      <type>uint32_t</type>
      <name>range</name>
      <anchorfile>structstg__laser__sample__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char</type>
      <name>reflectance</name>
      <anchorfile>structstg__laser__sample__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_point_t</name>
    <filename>structstg__point__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>x</name>
      <anchorfile>structstg__point__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>y</name>
      <anchorfile>structstg__point__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_polygon_t</name>
    <filename>structstg__polygon__t.html</filename>
    <member kind="variable">
      <type>GArray *</type>
      <name>points</name>
      <anchorfile>structstg__polygon__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>filled</name>
      <anchorfile>structstg__polygon__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_color_t</type>
      <name>color</name>
      <anchorfile>structstg__polygon__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_pose_t</name>
    <filename>structstg__pose__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>x</name>
      <anchorfile>structstg__pose__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>y</name>
      <anchorfile>structstg__pose__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>a</name>
      <anchorfile>structstg__pose__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_position_cmd_t</name>
    <filename>structstg__position__cmd__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>x</name>
      <anchorfile>structstg__position__cmd__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>y</name>
      <anchorfile>structstg__position__cmd__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>a</name>
      <anchorfile>structstg__position__cmd__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_position_control_mode_t</type>
      <name>mode</name>
      <anchorfile>structstg__position__cmd__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_position_data_t</name>
    <filename>structstg__position__data__t.html</filename>
    <member kind="variable">
      <type>stg_pose_t</type>
      <name>pose</name>
      <anchorfile>structstg__position__data__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_pose_t</type>
      <name>pose_error</name>
      <anchorfile>structstg__position__data__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_pose_t</type>
      <name>origin</name>
      <anchorfile>structstg__position__data__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_velocity_t</type>
      <name>velocity</name>
      <anchorfile>structstg__position__data__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_velocity_t</type>
      <name>integration_error</name>
      <anchorfile>structstg__position__data__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_bool_t</type>
      <name>stall</name>
      <anchorfile>structstg__position__data__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_position_localization_mode_t</type>
      <name>localization</name>
      <anchorfile>structstg__position__data__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_property</name>
    <filename>structstg__property.html</filename>
    <member kind="variable">
      <type>char</type>
      <name>name</name>
      <anchorfile>structstg__property.html</anchorfile>
      <anchor>o0</anchor>
      <arglist>[STG_PROPNAME_MAX]</arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>data</name>
      <anchorfile>structstg__property.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>len</name>
      <anchorfile>structstg__property.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_property_storage_func_t</type>
      <name>storage_func</name>
      <anchorfile>structstg__property.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>GList *</type>
      <name>callbacks</name>
      <anchorfile>structstg__property.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_model_t *</type>
      <name>mod</name>
      <anchorfile>structstg__property.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_rangecom_config_t</name>
    <filename>structstg__rangecom__config__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>max_range</name>
      <anchorfile>structstg__rangecom__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>wall_penalty</name>
      <anchorfile>structstg__rangecom__config__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_rangecom_t</name>
    <filename>structstg__rangecom__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>range</name>
      <anchorfile>structstg__rangecom__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>bearing</name>
      <anchorfile>structstg__rangecom__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char</type>
      <name>name</name>
      <anchorfile>structstg__rangecom__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist>[32]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_ranger_config_t</name>
    <filename>structstg__ranger__config__t.html</filename>
    <member kind="variable">
      <type>stg_pose_t</type>
      <name>pose</name>
      <anchorfile>structstg__ranger__config__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_size_t</type>
      <name>size</name>
      <anchorfile>structstg__ranger__config__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_bounds_t</type>
      <name>bounds_range</name>
      <anchorfile>structstg__ranger__config__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_radians_t</type>
      <name>fov</name>
      <anchorfile>structstg__ranger__config__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_ranger_sample_t</name>
    <filename>structstg__ranger__sample__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>range</name>
      <anchorfile>structstg__ranger__sample__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_rotrect_t</name>
    <filename>structstg__rotrect__t.html</filename>
    <member kind="variable">
      <type>stg_pose_t</type>
      <name>pose</name>
      <anchorfile>structstg__rotrect__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_size_t</type>
      <name>size</name>
      <anchorfile>structstg__rotrect__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>stg_size_t</name>
    <filename>structstg__size__t.html</filename>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>x</name>
      <anchorfile>structstg__size__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>stg_meters_t</type>
      <name>y</name>
      <anchorfile>structstg__size__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>extending</name>
    <title>Extending Stage with new models</title>
    <filename>extending</filename>
  </compound>
  <compound kind="page">
    <name>help</name>
    <title>Getting Help</title>
    <filename>help</filename>
  </compound>
  <compound kind="page">
    <name>faq</name>
    <title>Frequently Asked Questions (FAQ)</title>
    <filename>faq</filename>
  </compound>
  <compound kind="page">
    <name>refs</name>
    <title>References</title>
    <filename>refs</filename>
  </compound>
  <compound kind="page">
    <name>install</name>
    <title>Installation</title>
    <filename>install</filename>
  </compound>
  <compound kind="page">
    <name>release</name>
    <title>Release Notes</title>
    <filename>release</filename>
  </compound>
  <compound kind="page">
    <name>credits</name>
    <title>Credits</title>
    <filename>credits</filename>
  </compound>
  <compound kind="page">
    <name>dev_simulation</name>
    <title>Simulation Device</title>
    <filename>dev_simulation</filename>
  </compound>
  <compound kind="page">
    <name>devices</name>
    <title>Devices</title>
    <filename>devices</filename>
  </compound>
  <compound kind="page">
    <name>models</name>
    <title>Models</title>
    <filename>models</filename>
  </compound>
  <compound kind="group">
    <name>libstage</name>
    <title>libstage</title>
    <filename>group__libstage.html</filename>
    <subgroup>util</subgroup>
    <subgroup>defaults</subgroup>
    <subgroup>stg_world</subgroup>
    <subgroup>stg_models</subgroup>
    <subgroup>stg_model</subgroup>
    <member kind="define">
      <type>#define</type>
      <name>TRUE</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>FALSE</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>MILLION</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>BILLION</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>M_PI</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga10</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TWOPI</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga11</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RTOD</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga12</anchor>
      <arglist>(r)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>DTOR</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga13</anchor>
      <arglist>(d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>NORMALIZE</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga14</anchor>
      <arglist>(z)</arglist>
    </member>
    <member kind="function">
      <type>stg_msec_t</type>
      <name>stg_timenow</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_init</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(int argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>stg_get_version_string</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_quit_test</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_quit_request</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_err</name>
      <anchorfile>group__libstage.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist>(const char *err)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>util</name>
    <title>Utilities</title>
    <filename>group__util.html</filename>
    <subgroup>rotrect</subgroup>
    <subgroup>stg_point</subgroup>
    <subgroup>stg_polygon</subgroup>
    <member kind="function">
      <type>void</type>
      <name>stg_pose_sum</name>
      <anchorfile>group__util.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_pose_t *result, stg_pose_t *p1, stg_pose_t *p2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_print_geom</name>
      <anchorfile>group__util.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_geom_t *geom)</arglist>
    </member>
    <member kind="function">
      <type>stg_color_t</type>
      <name>stg_lookup_color</name>
      <anchorfile>group__util.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(const char *name)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>rotrect</name>
    <title>Rotated Rectangles</title>
    <filename>group__rotrect.html</filename>
    <class kind="struct">stg_rotrect_t</class>
    <member kind="function">
      <type>void</type>
      <name>stg_normalize_rects</name>
      <anchorfile>group__rotrect.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_rotrect_t *rects, int num)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_load_image</name>
      <anchorfile>group__rotrect.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(const char *filename, stg_rotrect_t **rects, int *rect_count, int *widthp, int *heightp)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_point</name>
    <title>Points</title>
    <filename>group__stg__point.html</filename>
    <class kind="struct">stg_point_t</class>
    <member kind="function">
      <type>stg_point_t *</type>
      <name>stg_points_create</name>
      <anchorfile>group__stg__point.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(size_t count)</arglist>
    </member>
    <member kind="function">
      <type>stg_point_t *</type>
      <name>stg_point_create</name>
      <anchorfile>group__stg__point.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_points_destroy</name>
      <anchorfile>group__stg__point.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(stg_point_t *pts)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_point_destroy</name>
      <anchorfile>group__stg__point.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist>(stg_point_t *pt)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_polygon</name>
    <title>Polygons</title>
    <filename>group__stg__polygon.html</filename>
    <class kind="struct">stg_polygon_t</class>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_polygons_create</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(int count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygons_destroy</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_polygon_t *p, size_t count)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_polygon_create</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_unit_polygon_create</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygon_destroy</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist>(stg_polygon_t *p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygon_set_points</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist>(stg_polygon_t *poly, stg_point_t *pts, size_t count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygon_append_points</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga6</anchor>
      <arglist>(stg_polygon_t *poly, stg_point_t *pts, size_t count)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_rects_to_polygons</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga7</anchor>
      <arglist>(stg_rotrect_t *rects, size_t count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_normalize_polygons</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga8</anchor>
      <arglist>(stg_polygon_t *polys, int num, double width, double height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygon_print</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga9</anchor>
      <arglist>(stg_polygon_t *poly)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_polygons_print</name>
      <anchorfile>group__stg__polygon.html</anchorfile>
      <anchor>ga10</anchor>
      <arglist>(stg_polygon_t *polys, unsigned int count)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>defaults</name>
    <title>Defaults</title>
    <filename>group__defaults.html</filename>
    <member kind="function">
      <type>void</type>
      <name>stg_get_default_pose</name>
      <anchorfile>group__defaults.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_pose_t *pose)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_get_default_geom</name>
      <anchorfile>group__defaults.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_geom_t *geom)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_world</name>
    <title>Worlds</title>
    <filename>group__stg__world.html</filename>
    <member kind="typedef">
      <type>_stg_world</type>
      <name>stg_world_t</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int(*</type>
      <name>stg_property_callback_t</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>)(stg_model_t *mod, char *name, void *data, size_t len, void *userdata)</arglist>
    </member>
    <member kind="typedef">
      <type>void(*</type>
      <name>stg_property_storage_func_t</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>)(struct stg_property *prop, void *data, size_t len)</arglist>
    </member>
    <member kind="function">
      <type>stg_world_t *</type>
      <name>stg_world_create</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist>(stg_id_t id, const char *token, int sim_interval, int real_interval, double ppm, double width, double height)</arglist>
    </member>
    <member kind="function">
      <type>stg_world_t *</type>
      <name>stg_world_create_from_file</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist>(const char *worldfile_path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_destroy</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist>(stg_world_t *world)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_stop</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga6</anchor>
      <arglist>(stg_world_t *world)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_start</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga7</anchor>
      <arglist>(stg_world_t *world)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_world_update</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga8</anchor>
      <arglist>(stg_world_t *world, int sleepflag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_load</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga9</anchor>
      <arglist>(stg_world_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_save</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga10</anchor>
      <arglist>(stg_world_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_print</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga11</anchor>
      <arglist>(stg_world_t *world)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_set_interval_real</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga12</anchor>
      <arglist>(stg_world_t *world, unsigned int val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_set_interval_sim</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga13</anchor>
      <arglist>(stg_world_t *world, unsigned int val)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_world_get_model</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga14</anchor>
      <arglist>(stg_world_t *world, stg_id_t mid)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_world_model_name_lookup</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga15</anchor>
      <arglist>(stg_world_t *world, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_add_property_callback</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga16</anchor>
      <arglist>(stg_world_t *world, char *propname, stg_property_callback_t callback, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_world_remove_property_callback</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga17</anchor>
      <arglist>(stg_world_t *world, char *propname, stg_property_callback_t callback)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_add_property_toggles</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga18</anchor>
      <arglist>(stg_model_t *mod, const char *propname, stg_property_callback_t callback_on, void *arg_on, stg_property_callback_t callback_off, void *arg_off, const char *label, int enabled)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_fig_clear_cb</name>
      <anchorfile>group__stg__world.html</anchorfile>
      <anchor>ga19</anchor>
      <arglist>(stg_model_t *mod, void *data, size_t len, void *userp)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_models</name>
    <title>Models</title>
    <filename>group__stg__models.html</filename>
    <subgroup>stg_model</subgroup>
    <subgroup>stg_model_blobfinder</subgroup>
    <subgroup>stg_model_laser</subgroup>
    <subgroup>stg_model_gripper</subgroup>
    <subgroup>stg_model_fiducial</subgroup>
    <subgroup>stg_model_rangecom</subgroup>
    <subgroup>stg_model_gps</subgroup>
    <subgroup>stg_model_compass</subgroup>
    <subgroup>stg_model_ranger</subgroup>
    <subgroup>stg_model_position</subgroup>
  </compound>
  <compound kind="group">
    <name>stg_model</name>
    <title>Basic model</title>
    <filename>group__stg__model.html</filename>
    <class kind="struct">stg_size_t</class>
    <class kind="struct">stg_pose_t</class>
    <class kind="struct">stg_geom_t</class>
    <class kind="struct">stg_energy_data_t</class>
    <class kind="struct">stg_energy_config_t</class>
    <class kind="struct">stg_guifeatures_t</class>
    <class kind="struct">stg_cbarg_t</class>
    <class kind="struct">stg_property</class>
    <member kind="define">
      <type>#define</type>
      <name>FiducialNone</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga56</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RangecomNone</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga57</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RangecomImpede</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga58</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RangecomPoint</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga59</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_MOVE_TRANS</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga60</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_MOVE_ROT</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga61</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_MOVE_SCALE</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga62</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_PROPNAME_MAX</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga63</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_id_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_meters_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_radians_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned long</type>
      <name>stg_msec_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_kg_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_joules_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_watts_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_bool_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>double</type>
      <name>stg_friction_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>uint32_t</type>
      <name>stg_color_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_obstacle_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga10</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_blob_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga11</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_fiducial_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga12</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_rangecom_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga13</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_ranger_return_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga14</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>stg_pose_t</type>
      <name>stg_velocity_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga15</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_movemask_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga16</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>_stg_model</type>
      <name>stg_model_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga17</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>stg_property</type>
      <name>stg_property_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga18</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int(*</type>
      <name>stg_model_initializer_t</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga19</anchor>
      <arglist>)(stg_model_t *)</arglist>
    </member>
    <member kind="enumeration">
      <name>stg_gripper_return_t</name>
      <anchor>ga64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIP_NO</name>
      <anchor>gga64a45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIP_YES</name>
      <anchor>gga64a46</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_laser_return_t</name>
      <anchor>ga65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LaserTransparent</name>
      <anchor>gga65a47</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LaserVisible</name>
      <anchor>gga65a48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LaserBright</name>
      <anchor>gga65a49</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_model_create</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga20</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token, stg_model_initializer_t initializer)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_destroy</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga21</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_get_global_pose</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga22</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *pose)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_get_global_velocity</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga23</anchor>
      <arglist>(stg_model_t *mod, stg_velocity_t *gvel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_subscribe</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga24</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_unsubscribe</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga25</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_load</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga26</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_save</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga27</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_set_global_pose</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga28</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *gpose)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_set_velocity</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga29</anchor>
      <arglist>(stg_model_t *mod, stg_velocity_t *vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_lock</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga30</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_unlock</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga31</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_set_parent</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga32</anchor>
      <arglist>(stg_model_t *mod, stg_model_t *newparent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_get_geom</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga33</anchor>
      <arglist>(stg_model_t *mod, stg_geom_t *dest)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_get_velocity</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga34</anchor>
      <arglist>(stg_model_t *mod, stg_velocity_t *dest)</arglist>
    </member>
    <member kind="function">
      <type>stg_property_t *</type>
      <name>stg_model_set_property</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga35</anchor>
      <arglist>(stg_model_t *mod, const char *prop, void *data, size_t len)</arglist>
    </member>
    <member kind="function">
      <type>stg_property_t *</type>
      <name>stg_model_set_property_ex</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga36</anchor>
      <arglist>(stg_model_t *mod, const char *prop, void *data, size_t len, stg_property_storage_func_t func)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>stg_model_get_property</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga37</anchor>
      <arglist>(stg_model_t *mod, const char *prop, size_t *len)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>stg_model_get_property_fixed</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga38</anchor>
      <arglist>(stg_model_t *mod, const char *name, size_t size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_property_refresh</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga39</anchor>
      <arglist>(stg_model_t *mod, const char *propname)</arglist>
    </member>
    <member kind="function">
      <type>stg_polygon_t *</type>
      <name>stg_model_get_polygons</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga40</anchor>
      <arglist>(stg_model_t *mod, size_t *poly_count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_set_polygons</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga41</anchor>
      <arglist>(stg_model_t *mod, stg_polygon_t *polys, size_t poly_count)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_add_property_callback</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga42</anchor>
      <arglist>(stg_model_t *mod, const char *prop, stg_property_callback_t, void *user)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_remove_property_callback</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga43</anchor>
      <arglist>(stg_model_t *mod, const char *prop, stg_property_callback_t)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_remove_property_callbacks</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga44</anchor>
      <arglist>(stg_model_t *mod, const char *prop)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_print</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga45</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_is_antecedent</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga46</anchor>
      <arglist>(stg_model_t *mod, stg_model_t *testmod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_is_descendent</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga47</anchor>
      <arglist>(stg_model_t *mod, stg_model_t *testmod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_is_related</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga48</anchor>
      <arglist>(stg_model_t *mod1, stg_model_t *mod2)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_model_root</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga49</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_tree_to_ptr_array</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga50</anchor>
      <arglist>(stg_model_t *root, GPtrArray *array)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_startup</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga51</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_shutdown</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga52</anchor>
      <arglist>(stg_model_t *mod)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stg_model_update</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga53</anchor>
      <arglist>(stg_model_t *model)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_global_to_local</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga54</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *pose)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_local_to_global</name>
      <anchorfile>group__stg__model.html</anchorfile>
      <anchor>ga55</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *pose)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_model_blobfinder</name>
    <title>Blobfinder</title>
    <filename>group__stg__model__blobfinder.html</filename>
    <class kind="struct">stg_blobfinder_config_t</class>
    <class kind="struct">stg_blobfinder_blob_t</class>
    <member kind="define">
      <type>#define</type>
      <name>STG_BLOB_CHANNELS_MAX</name>
      <anchorfile>group__stg__model__blobfinder.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_blobfinder_create</name>
      <anchorfile>group__stg__model__blobfinder.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_model_laser</name>
    <title>Laser range scanner</title>
    <filename>group__stg__model__laser.html</filename>
    <class kind="struct">stg_laser_sample_t</class>
    <class kind="struct">stg_laser_config_t</class>
    <member kind="function">
      <type>void</type>
      <name>stg_print_laser_config</name>
      <anchorfile>group__stg__model__laser.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_laser_config_t *slc)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_laser_create</name>
      <anchorfile>group__stg__model__laser.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>stg_model_get_data_laser</name>
      <anchorfile>group__stg__model__laser.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(stg_model_t *mod, stg_laser_sample_t *data, size_t max_samples)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_model_gripper</name>
    <title>Gripper</title>
    <filename>group__stg__model__gripper.html</filename>
    <class kind="struct">stg_gripper_config_t</class>
    <class kind="struct">stg_gripper_cmd_t</class>
    <class kind="struct">stg_gripper_data_t</class>
    <member kind="enumeration">
      <name>stg_gripper_paddle_state_t</name>
      <anchor>ga2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_PADDLE_OPEN</name>
      <anchor>gga2a50</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_PADDLE_CLOSED</name>
      <anchor>gga2a51</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_PADDLE_OPENING</name>
      <anchor>gga2a52</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_PADDLE_CLOSING</name>
      <anchor>gga2a53</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_gripper_lift_state_t</name>
      <anchor>ga3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_LIFT_DOWN</name>
      <anchor>gga3a54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_LIFT_UP</name>
      <anchor>gga3a55</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_LIFT_UPPING</name>
      <anchor>gga3a56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_LIFT_DOWNING</name>
      <anchor>gga3a57</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_gripper_cmd_type_t</name>
      <anchor>ga4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_NOP</name>
      <anchor>gga4a58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_OPEN</name>
      <anchor>gga4a59</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_CLOSE</name>
      <anchor>gga4a60</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_UP</name>
      <anchor>gga4a61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_GRIPPER_CMD_DOWN</name>
      <anchor>gga4a62</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_print_gripper_config</name>
      <anchorfile>group__stg__model__gripper.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_gripper_config_t *slc)</arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_gripper_create</name>
      <anchorfile>group__stg__model__gripper.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_model_fiducial</name>
    <title>Fidicial detector</title>
    <filename>group__stg__model__fiducial.html</filename>
    <class kind="struct">stg_fiducial_config_t</class>
    <class kind="struct">stg_fiducial_t</class>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_fiducial_create</name>
      <anchorfile>group__stg__model__fiducial.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_model_rangecom</name>
    <title>Ranged Communication Detector</title>
    <filename>group__stg__model__rangecom.html</filename>
    <class kind="struct">stg_rangecom_config_t</class>
    <class kind="struct">stg_rangecom_t</class>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_rangecom_create</name>
      <anchorfile>group__stg__model__rangecom.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_model_gps</name>
    <title>GPS</title>
    <filename>group__stg__model__gps.html</filename>
    <class kind="struct">stg_gps_config_t</class>
    <class kind="struct">stg_gps_t</class>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_gps_create</name>
      <anchorfile>group__stg__model__gps.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_model_compass</name>
    <title>Compass</title>
    <filename>group__stg__model__compass.html</filename>
    <class kind="struct">stg_compass_config_t</class>
    <class kind="struct">stg_compass_t</class>
  </compound>
  <compound kind="group">
    <name>stg_model_ranger</name>
    <title>Range finder</title>
    <filename>group__stg__model__ranger.html</filename>
    <class kind="struct">stg_bounds_t</class>
    <class kind="struct">stg_fov_t</class>
    <class kind="struct">stg_ranger_config_t</class>
    <class kind="struct">stg_ranger_sample_t</class>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_ranger_create</name>
      <anchorfile>group__stg__model__ranger.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>stg_model_position</name>
    <title>Position</title>
    <filename>group__stg__model__position.html</filename>
    <class kind="struct">stg_position_cmd_t</class>
    <class kind="struct">stg_position_data_t</class>
    <member kind="define">
      <type>#define</type>
      <name>STG_POSITION_CONTROL_DEFAULT</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_POSITION_LOCALIZATION_DEFAULT</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>STG_POSITION_DRIVE_DEFAULT</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>stg_position_stall_t</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_position_control_mode_t</name>
      <anchor>ga6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_CONTROL_VELOCITY</name>
      <anchor>gga6a63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_CONTROL_POSITION</name>
      <anchor>gga6a64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_position_localization_mode_t</name>
      <anchor>ga7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_LOCALIZATION_GPS</name>
      <anchor>gga7a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_LOCALIZATION_ODOM</name>
      <anchor>gga7a66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>stg_position_drive_mode_t</name>
      <anchor>ga8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_DRIVE_DIFFERENTIAL</name>
      <anchor>gga8a67</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>STG_POSITION_DRIVE_OMNI</name>
      <anchor>gga8a68</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>stg_model_t *</type>
      <name>stg_position_create</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist>(stg_world_t *world, stg_model_t *parent, stg_id_t id, char *token)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stg_model_position_set_odom</name>
      <anchorfile>group__stg__model__position.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist>(stg_model_t *mod, stg_pose_t *odom)</arglist>
    </member>
  </compound>
  <compound kind="dir">
    <name>/home/jamuraa/sources/stage-arch/src/</name>
    <path>/home/jamuraa/sources/stage-arch/src/</path>
    <filename>dir_000000.html</filename>
    <file>stage.h</file>
  </compound>
</tagfile>
