#!/usr/bin/tclsh

#
# saphconv.tcl
#
#   parse Saphira robot parameter files and generate a header file for Player
#

set USAGE "saphconv.tcl <files>"

if {$argc < 1} {
  puts $USAGE
  exit
}

set fdc [open robot_params.cc w]
set fdh [open robot_params.h w]
puts $fdc "/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2000
 *     Brian Gerkey, Kasper Stoy, Richard Vaughan, & Andrew Howard
 *                   
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
"

puts $fdc "/* 
 * robot_params.cc 
 *
 * ActivMedia robot parameters, automatically generated by saphconv.tcl from 
 * Saphira parameter files:"
foreach fname $argv {
  puts $fdc " *    $fname"
}
puts $fdc "*/
#include <robot_params.h>
"

puts $fdh "/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2000
 *     Brian Gerkey, Kasper Stoy, Richard Vaughan, & Andrew Howard
 *                   
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
"

puts $fdh "/* 
 * robot_params.h 
 *
 * ActivMedia robot parameters, automatically generated by saphconv.tcl from 
 * Saphira parameter files:"
foreach fname $argv {
  puts $fdh " *    $fname"
}
puts $fdh "*/

#ifndef _ROBOT_PARAMS_H
#define _ROBOT_PARAMS_H\n\n"

close $fdc
close $fdh
eval exec ./mktypedef.tcl $argv >> robot_params.h
eval exec ./parseparam.tcl $argv >> robot_params.cc

set fdh [open robot_params.h a]
puts $fdh "\n\n#endif"
close $fdh

