// mother.h - wrappers for the Nomad client functions
// copyright Pawel Zebrowski, Richard Vaughan 2004, released under the GPL.


/////////////////////////////////////////////////////////////////////////
// converts tens of inches to millimeters
int inchesToMM(int inches);

/////////////////////////////////////////////////////////////////////////
// converts millimeters to tens of inches
int mmToInches(int mm);


/////////////////////////////////////////////////////////////////////////
// connects to the robot and performs any other connection setup that
// may be required
void connectToRobot();

/////////////////////////////////////////////////////////////////////////
// cleans up and disconnects from the robot
void disconnectFromRobot();
    

/////////////////////////////////////////////////////////////////////////
// make the robot speak
void speak(char* s);


/////////////////////////////////////////////////////////////////////////
// initializes the robot
void initRobot();

/////////////////////////////////////////////////////////////////////////
// update sensor data, to be used before reading/processing sensor data
void readRobot();


/////////////////////////////////////////////////////////////////////////
// set the robot speed, turnrate, and turret in velocity mode.  
// Convert units first
void setSpeed(int speed, int turnrate, int turret);

/////////////////////////////////////////////////////////////////////////
// set te robot speed and turnrate in velocity mode.  Make the turret
// turn with the robot.  Convert units first
void setSpeed(int speed, int turnrate);

/////////////////////////////////////////////////////////////////////////
// set the odometry of the robot.  Set the turret the same as the base
void setOdometry(int x, int y, int theta);

/////////////////////////////////////////////////////////////////////////
// reset the odometry.
void resetOdometry();

/////////////////////////////////////////////////////////////////////////
// retreive the x position of the robot
int xPos();
int yPos();
int theta();
int speed();
int turnrate();

/////////////////////////////////////////////////////////////////////////
// updates sonarData array with the latest sonar data.  Converts units
void getSonar(int sonarData[16]);
