/*
 * Player WiFiInterface Example
 *
 * In order to compile: 
 * javac -cp javaclient.jar WifiExample.java
 *
 * To run: 
 * java -cp javaclient.jar:. WifiExample
 *
 * This just simply prints the data. 
 */

import javaclient.PlayerClient;
import javaclient.WiFiInterface;

public class WifiExample {

    public static void main (String[] args) {
	// Connect to the Player server and request access to Position and Sonar
        PlayerClient   	  robot = new PlayerClient ("localhost", 6666);
        WiFiInterface      wifi = robot.requestInterfaceWiFi (0, 'r');

        robot.runThreaded (-1, -1);

        try { Thread.sleep (1000); } catch (Exception e) { }

        while (true) {
    	    // get Wifi Values
          printWifi(wifi); 
          try { Thread.sleep(100); } catch (Exception e) { }  
        }
    }

    static void printWifi (WiFiInterface wifi) {
      WiFiInterface.WiFiLink[] links = wifi.getLinks(); 
      int amt = wifi.getLinkCount();
      System.out.println("WifiExample - printing " + amt + " links");
      for (int i = 0; i < amt; i++) { 
        System.out.println("Link" + i + ": " + new String(links[i].mac) + "," + new String(links[i].ip) + "," + new String(links[i].essid)); 
      }

    }

}
