/*
 * Decompiled with CFR 0.152.
 */
package javaclient.extra;

import java.awt.Point;
import javaclient.AbstractPositionDevice;
import javaclient.PlayerClient;
import javaclient.extra.PIDController;
import javaclient.extra.PositionGeometryTools;

public class PositionControl
extends PIDController {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private AbstractPositionDevice device = null;
    private int Kp = 1;
    private int Ki = 0;
    private int Kd = 0;
    private boolean stop = false;
    private int minCommand = 1;
    private int maxCommand = 100;
    private int maxError = 10;

    public PositionControl(AbstractPositionDevice pd) {
        super(1.0, 0.0, 0.0);
        this.device = pd;
    }

    public PositionControl(AbstractPositionDevice pd, int kp, int ki, int kd) {
        super(kp, ki, kd);
        this.Kp = kp;
        this.Ki = ki;
        this.Kd = kd;
        this.device = pd;
    }

    public PositionControl(AbstractPositionDevice pd, int minC, int maxC) {
        super(1.0, 0.0, 0.0);
        this.minCommand = minC;
        this.maxCommand = maxC;
        this.device = pd;
    }

    public PositionControl(AbstractPositionDevice pd, int minC, int maxC, int kp, int ki, int kd) {
        super(kp, ki, kd);
        this.minCommand = minC;
        this.maxCommand = maxC;
        this.Kp = kp;
        this.Ki = ki;
        this.Kd = kd;
        this.device = pd;
    }

    public void setMinimumCommand(int minC) {
        this.minCommand = minC;
    }

    public void setMaximumCommand(int maxC) {
        this.maxCommand = maxC;
    }

    public void setAllowedError(int err) {
        this.maxError = err;
    }

    public void stopRobot() {
        this.stop = true;
    }

    public Point getRobotPosition() {
        return new Point(this.device.getX(), this.device.getY());
    }

    private int boundCommand(int command) {
        if (command == 0) {
            return 0;
        }
        if (command < 0) {
            if (command > -this.minCommand) {
                command = -this.minCommand;
            }
            if (command < -this.maxCommand) {
                command = -this.maxCommand;
            }
        } else {
            if (command < this.minCommand) {
                command = this.minCommand;
            }
            if (command > this.maxCommand) {
                command = this.maxCommand;
            }
        }
        return command;
    }

    public boolean moveRobot(int distance) {
        this.stop = false;
        boolean ret = true;
        int dist = distance;
        int angle = this.device.getYaw();
        Point roboPos = this.getRobotPosition();
        Point dest = PositionGeometryTools.calcDistPoint(roboPos, distance, angle);
        dist = PositionGeometryTools.calcDist(dest, roboPos);
        this.setGoal(0.0);
        int sgn = -1;
        if (distance < 0) {
            sgn = 1;
        }
        while (dist > 0) {
            if (this.stop) {
                ret = false;
                break;
            }
            roboPos = this.getRobotPosition();
            dist = PositionGeometryTools.calcDist(dest, roboPos);
            int erX = roboPos.x - dest.x;
            int erY = roboPos.y - dest.y;
            if (dist <= this.maxError || erX == 0 && Math.abs(erY) <= 10 || erY == 0 && Math.abs(erX) <= 10) break;
            int command = (int)this.getCommand(dist);
            command = this.boundCommand(command);
            this.device.setSpeed(sgn * command, 0);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isDebugging) continue;
            System.err.println("[PositionControl][Debug] Distance left : " + dist);
        }
        this.device.setSpeed(0, 0);
        roboPos = this.getRobotPosition();
        dist = PositionGeometryTools.calcDist(dest, roboPos);
        if (dist != 0 && isDebugging) {
            System.err.println("[PositionControl][Debug] Distance error : " + dist);
        }
        return ret;
    }
}

