/*
 * Decompiled with CFR 0.152.
 */
package javaclient.extra;

import javaclient.AbstractPositionDevice;
import javaclient.PlayerClient;
import javaclient.extra.PIDController;

public class HeadingControl
extends PIDController {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private AbstractPositionDevice device = null;
    private int Kp = 1;
    private int Ki = 0;
    private int Kd = 0;
    private boolean stop = false;
    private int minCommand = 1;
    private int maxCommand = 180;
    private int maxError = 0;

    public HeadingControl(AbstractPositionDevice pd) {
        super(1.0, 0.0, 0.0);
        this.device = pd;
    }

    public HeadingControl(AbstractPositionDevice pd, int kp, int ki, int kd) {
        super(kp, ki, kd);
        this.Kp = kp;
        this.Ki = ki;
        this.Kd = kd;
        this.device = pd;
    }

    public HeadingControl(AbstractPositionDevice pd, int minC, int maxC) {
        super(1.0, 0.0, 0.0);
        this.minCommand = minC;
        this.maxCommand = maxC;
        this.device = pd;
    }

    public HeadingControl(AbstractPositionDevice pd, int minC, int maxC, int kp, int ki, int kd) {
        super(kp, ki, kd);
        this.minCommand = minC;
        this.maxCommand = maxC;
        this.Kp = kp;
        this.Ki = ki;
        this.Kd = kd;
        this.device = pd;
    }

    public void setMinimumCommand(int minC) {
        this.minCommand = minC;
    }

    public void setMaximumCommand(int maxC) {
        this.maxCommand = maxC;
    }

    public void stopRobot() {
        this.stop = true;
    }

    public void setAllowedError(int err) {
        this.maxError = err;
    }

    public double getCommand(double currentOutput) {
        this.currE = this.goal - currentOutput;
        if (this.currE <= -180.0) {
            this.currE = 360.0 + this.currE;
        } else if (this.currE >= 180.0 && this.currE <= 360.0) {
            this.currE -= 360.0;
        } else if (this.currE > 360.0) {
            this.currE -= 360.0;
        }
        this.eSum += this.currE;
        this.lastE = this.currE;
        double Pgain = (double)this.Kp * this.currE;
        double Igain = (double)this.Ki * this.eSum;
        double Dgain = (double)this.Kd * this.deltaE();
        return Pgain + Igain + Dgain;
    }

    private int boundCommand(int command) {
        if (command == 0) {
            return 0;
        }
        if (command < 0) {
            if (command > -this.minCommand) {
                command = -this.minCommand;
            }
            if (command < -this.maxCommand) {
                command = -this.maxCommand;
            }
        } else {
            if (command < this.minCommand) {
                command = this.minCommand;
            }
            if (command > this.maxCommand) {
                command = this.maxCommand;
            }
        }
        return command;
    }

    private int transformAngle(int angle) {
        if ((angle %= 360) < 0) {
            angle = 360 + angle;
        }
        return angle;
    }

    public boolean setDiffHeading(int angle) {
        if (angle == 0) {
            return true;
        }
        this.stop = false;
        boolean ret = true;
        double currentHead = this.transformAngle(this.device.getYaw());
        double newGoal = this.transformAngle((int)(currentHead + (double)angle));
        this.setGoal(newGoal);
        double now = this.transformAngle(this.device.getYaw());
        while (now != newGoal) {
            if (this.stop) {
                ret = false;
                break;
            }
            if (Math.abs(now - newGoal) <= 1.0 && newGoal == 180.0 || Math.abs(now - newGoal) <= (double)this.maxError) break;
            now = this.transformAngle(this.device.getYaw());
            int command = (int)this.getCommand(now);
            command = this.boundCommand(command);
            this.device.setSpeed(0, command);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isDebugging) continue;
            System.err.println("[HeadingControl][Debug] Angle left : " + Math.abs(now - newGoal));
        }
        this.device.setSpeed(0, 0);
        return ret;
    }

    public boolean setHeading(int angle) {
        int currentAngle = this.transformAngle(this.device.getYaw());
        int deltaAngle = angle - currentAngle;
        if (deltaAngle != 0) {
            if (deltaAngle <= 180 && deltaAngle > 0) {
                return this.setDiffHeading(deltaAngle);
            }
            if (deltaAngle > -180) {
                return this.setDiffHeading(-360 + deltaAngle);
            }
            return this.setDiffHeading(360 + deltaAngle);
        }
        return true;
    }
}

