/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class WiFiInterface
extends PlayerDevice {
    private final short PLAYER_WIFI_CODE = (short)23;
    private int linkCount = 0;
    private int throughput;
    private int bitrate;
    private int mode;
    private int qualType;
    private int maxQual;
    private int maxLevel;
    private int maxNoise;
    private char[] ap = new char[32];
    private WiFiLink[] links = new WiFiLink[32];
    public byte[] debug = new byte[2048];

    public WiFiInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)23;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            int i;
            for (i = 0; i < 32; ++i) {
                int j;
                this.links[i] = new WiFiLink();
                for (j = 0; j < 32; ++j) {
                    this.links[i].mac[j] = (char)this.is.readByte();
                }
                for (j = 0; j < 32; ++j) {
                    this.links[i].ip[j] = (char)this.is.readByte();
                }
                for (j = 0; j < 32; ++j) {
                    this.links[i].essid[j] = (char)this.is.readByte();
                }
                this.links[i].mode = this.is.readUnsignedByte();
                this.links[i].freq = this.is.readUnsignedShort();
                this.links[i].encrypt = this.is.readUnsignedByte();
                this.links[i].qual = this.is.readUnsignedShort();
                this.links[i].level = this.is.readUnsignedShort();
                this.links[i].noise = this.is.readUnsignedShort();
            }
            this.linkCount = this.is.readUnsignedShort();
            this.throughput = this.is.readInt();
            this.bitrate = this.is.readInt();
            this.mode = this.is.readUnsignedByte();
            this.qualType = this.is.readUnsignedByte();
            this.maxQual = this.is.readUnsignedShort();
            this.maxLevel = this.is.readUnsignedShort();
            this.maxNoise = this.is.readUnsignedShort();
            for (i = 0; i < 32; ++i) {
                this.ap[i] = (char)this.is.readByte();
            }
        }
        catch (Exception e) {
            System.err.println("[WiFi] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized WiFiLink[] getLinks() {
        return this.links;
    }

    public synchronized int getLinkCount() {
        return this.linkCount;
    }

    public class WiFiLink {
        public char[] mac = new char[32];
        public char[] ip = new char[32];
        public char[] essid = new char[32];
        public int mode;
        public int freq;
        public int encrypt;
        public int qual;
        public int level;
        public int noise;
    }
}

