/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class WaveformInterface
extends PlayerDevice {
    private final short PLAYER_WAVEFORM_CODE = (short)24;
    public static final short PLAYER_WAVEFORM_DATA_MAX = 4096;
    private int rate;
    private int depth;
    private int samples;
    private byte[] data = new byte[4096];

    public WaveformInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)24;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.rate = this.is.readInt();
            this.depth = this.is.readUnsignedShort();
            this.samples = this.is.readInt();
            if (this.samples > 4096) {
                this.samples = 4096;
            }
            for (int i = 0; i < this.samples; ++i) {
                this.data[i] = (byte)this.is.readUnsignedByte();
            }
        }
        catch (Exception e) {
            System.err.println("[Waveform] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int getRate() {
        return this.rate;
    }

    public synchronized int getDepth() {
        return this.depth;
    }

    public synchronized int getSamples() {
        return this.samples;
    }

    public synchronized byte[] getData() {
        return this.data;
    }
}

