/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class TruthInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_TRUTH_CODE = (short)15;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    protected final short PLAYER_TRUTH_GET_POSE = 0;
    protected final short PLAYER_TRUTH_SET_POSE = 1;
    protected final short PLAYER_TRUTH_SET_POSE_ON_ROOT = (short)2;
    protected final short PLAYER_TRUTH_GET_FIDUCIAL_ID = (short)3;
    protected final short PLAYER_TRUTH_SET_FIDUCIAL_ID = (short)4;
    private int xPos = 0;
    private int yPos = 0;
    private int zPos = 0;
    private int rHead = 0;
    private int pHead = 0;
    private int yHead = 0;
    private boolean isTeleported = false;

    public TruthInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)15;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.xPos = this.is.readInt();
            this.yPos = this.is.readInt();
            this.zPos = this.is.readInt();
            this.rHead = this.is.readInt();
            this.pHead = this.is.readInt();
            this.yHead = this.is.readInt();
        }
        catch (Exception e) {
            System.err.println("[Truth] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int getXpos() {
        return this.xPos;
    }

    public synchronized int getYpos() {
        return this.yPos;
    }

    public synchronized int getZpos() {
        return this.zPos;
    }

    public synchronized int getRhead() {
        return this.rHead;
    }

    public synchronized int getPhead() {
        return this.pHead;
    }

    public synchronized int getYhead() {
        return this.yHead;
    }

    public void teleport(int x, int y) {
        try {
            this.sendHeader((short)3, 25);
            this.os.writeByte(1);
            this.os.writeInt(x);
            this.os.writeInt(y);
            this.os.writeInt(this.zPos);
            this.os.writeInt(this.rHead);
            this.os.writeInt(this.pHead);
            this.os.writeInt(this.yHead);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Truth] : Couldn't send PLAYER_TRUTH_SET_POSE command: " + e.toString());
        }
        this.isTeleported = !this.isTeleported;
    }

    public void teleport(int x, int y, int z) {
        try {
            this.sendHeader((short)3, 25);
            this.os.writeByte(1);
            this.os.writeInt(x);
            this.os.writeInt(y);
            this.os.writeInt(z);
            this.os.writeInt(this.rHead);
            this.os.writeInt(this.pHead);
            this.os.writeInt(this.yHead);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Truth] : Couldn't send PLAYER_TRUTH_SET_POSE command: " + e.toString());
        }
        this.isTeleported = !this.isTeleported;
    }

    public void teleport(int xp, int yp, int zp, int ro, int po, int yo) {
        try {
            this.sendHeader((short)3, 25);
            this.os.writeByte(1);
            this.os.writeInt(xp);
            this.os.writeInt(yp);
            this.os.writeInt(zp);
            this.os.writeInt(ro);
            this.os.writeInt(po);
            this.os.writeInt(yo);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Truth] : Couldn't send PLAYER_TRUTH_SET_POSE command: " + e.toString());
        }
        this.isTeleported = !this.isTeleported;
    }

    public boolean isTeleported() {
        return this.isTeleported;
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Truth][Debug] : Unexpected response of size 0!");
            }
            return;
        }
    }
}

