/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.PlayerSonarGeomT;

public class SonarInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_SONAR_CODE = (short)5;
    protected final short PLAYER_SONAR_GET_GEOM_REQ = 1;
    protected final short PLAYER_SONAR_POWER_REQ = (short)2;
    private final short PLAYER_MSGTYPE_REQ = (short)3;
    public static final short PLAYER_SONAR_MAX_SAMPLES = 64;
    private int[] range = new int[64];
    private int samplesCount = 64;
    private PlayerSonarGeomT psgt;
    private boolean readyPSGT = false;

    public SonarInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)5;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.samplesCount = this.is.readUnsignedShort();
            for (int i = 0; i < 64; ++i) {
                this.range[i] = this.is.readUnsignedShort();
            }
        }
        catch (Exception e) {
            System.err.println("[Sonar] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int[] getRanges() {
        return this.range;
    }

    public synchronized int getSamplesCount() {
        return this.samplesCount;
    }

    public void queryGeometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Sonar] : Couldn't send PLAYER_SONAR_GET_GEOM_REQ command: " + e.toString());
        }
    }

    public void setSonarPower(int value) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(2);
            this.os.writeByte((byte)value);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Sonar] : Couldn't send PLAYER_SONAR_POWER_REQ command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Sonar][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    this.psgt = new PlayerSonarGeomT();
                    this.psgt.setPoseCount(this.is.readShort());
                    short[][] sonarPoses = new short[64][3];
                    for (int i = 0; i < 64; ++i) {
                        sonarPoses[i][0] = this.is.readShort();
                        sonarPoses[i][1] = this.is.readShort();
                        sonarPoses[i][2] = this.is.readShort();
                    }
                    this.psgt.setPoses(sonarPoses);
                    this.readyPSGT = true;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    System.err.println("[Sonar] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Sonar] : Error when reading payload " + e.toString());
        }
    }

    public boolean isPSGTReady() {
        if (this.readyPSGT) {
            this.readyPSGT = false;
            return true;
        }
        return false;
    }

    public PlayerSonarGeomT getPSGT() {
        return this.psgt;
    }
}

