/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.PlayerSimulationPose2D;

public class SimulationInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_SIMULATION_CODE = (short)31;
    private final short PLAYER_MSGTYPE_REQ = (short)3;
    protected final short PLAYER_SIMULATION_SET_POSE2D = 0;
    protected final short PLAYER_SIMULATION_GET_POSE2D = 1;
    public static final short PLAYER_SIMULATION_IDENTIFIER_MAXLEN = 64;
    private PlayerSimulationPose2D psp2d;
    private boolean readyPSP2D = false;

    public SimulationInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)31;
        this.index = indexOfDevice;
    }

    public void set2DPose(String identifier, int x, int y, int theta) {
        try {
            int i;
            int size = 77;
            this.sendHeader((short)3, size);
            this.os.writeByte(0);
            char[] ident = identifier.toCharArray();
            for (i = 0; i < identifier.length(); ++i) {
                this.os.writeByte(ident[i]);
            }
            for (i = 0; i < 64 - identifier.length(); ++i) {
                this.os.writeByte(0);
            }
            this.os.writeInt(x);
            this.os.writeInt(y);
            this.os.writeInt(theta);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Simulation] : Couldn't send PLAYER_SIMULATION_SET_POSE2D command: " + e.toString());
        }
    }

    public void get2DPose(String identifier) {
        try {
            int i;
            int size = 65;
            this.sendHeader((short)3, size);
            this.os.writeByte(1);
            char[] ident = identifier.toCharArray();
            for (i = 0; i < identifier.length(); ++i) {
                this.os.writeByte(ident[i]);
            }
            for (i = 0; i < 64 - identifier.length(); ++i) {
                this.os.writeByte(0);
            }
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Simulation] : Couldn't send PLAYER_SIMULATION_GET_POSE2D command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Simulation][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            short subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    this.psp2d = new PlayerSimulationPose2D();
                    this.readyPSP2D = true;
                    String psp2dName = new String();
                    for (int j = 0; j < 64; ++j) {
                        psp2dName = psp2dName + (char)this.is.readByte();
                    }
                    this.psp2d.setName(psp2dName);
                    this.psp2d.setX(this.is.readInt());
                    this.psp2d.setY(this.is.readInt());
                    this.psp2d.setTheta(this.is.readInt());
                    break;
                }
                default: {
                    System.err.println("[Simulation] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Simulation] : Error when reading payload " + e.toString());
        }
    }

    public void handleNARMessage() {
        try {
            int size = this.is.readInt();
            System.err.println("[Simulation] : Handling NAR of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Simulation] : handleResponsePosition ERROR " + e.toString());
        }
    }

    public PlayerSimulationPose2D getSimulationPose2D() {
        return this.psp2d;
    }

    public boolean isPose2DReady() {
        if (this.readyPSP2D) {
            this.readyPSP2D = false;
            return true;
        }
        return false;
    }
}

