/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class PtzInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_PTZ_CODE = (short)8;
    private static final short PLAYER_MSGTYPE_CMD = 2;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    public final short PLAYER_PTZ_MAX_CONFIG_LEN = (short)32;
    protected final short PLAYER_PTZ_GENERIC_CONFIG_REQ = 1;
    protected final short PLAYER_PTZ_CONTROL_MODE_REQ = (short)2;
    protected final short PLAYER_PTZ_AUTOSERVO = (short)3;
    private short pan;
    private short tilt;
    private short zoom;
    private short panSpeed;
    private short tiltSpeed;

    public PtzInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)8;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.pan = this.is.readShort();
            this.tilt = this.is.readShort();
            this.zoom = this.is.readShort();
            this.panSpeed = this.is.readShort();
            this.tiltSpeed = this.is.readShort();
        }
        catch (Exception e) {
            System.err.println("[Ptz] : Error when reading payload: " + e.toString());
        }
    }

    public void setPTZ(int pan, int tilt, int zoom, int panspeed, int tiltspeed) {
        try {
            this.sendHeader((short)2, 10);
            this.os.writeShort((short)pan);
            this.os.writeShort((short)tilt);
            this.os.writeShort((short)zoom);
            this.os.writeShort((short)panspeed);
            this.os.writeShort((short)tiltspeed);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Ptz] : Couldn't send set PTZ parameters command: " + e.toString());
        }
    }

    public void genericRequest(int length, byte[] buf) {
        if (length > 32) {
            length = 32;
        }
        try {
            this.sendHeader((short)3, length + 3);
            this.os.writeByte(1);
            this.os.writeShort((short)length);
            for (int i = 0; i < length; ++i) {
                this.os.writeByte(buf[i]);
            }
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Ptz] : Couldn't send PLAYER_PTZ_GENERIC_CONFIG_REQ command: " + e.toString());
        }
    }

    public void controlRequest(int mode) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(2);
            this.os.writeByte((byte)mode);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Ptz] : Couldn't send PLAYER_PTZ_CONTROL_MODE_REQ command: " + e.toString());
        }
    }

    public void setAutoServo(int mode) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(3);
            this.os.writeByte((byte)mode);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Ptz] : Couldn't send PLAYER_PTZ_AUTOSERVO command: " + e.toString());
        }
    }

    public synchronized short getPan() {
        return this.pan;
    }

    public synchronized short getTilt() {
        return this.tilt;
    }

    public synchronized short getZoom() {
        return this.zoom;
    }

    public synchronized short getPanSpeed() {
        return this.panSpeed;
    }

    public synchronized short getTiltSpeed() {
        return this.tiltSpeed;
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Ptz][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    System.err.println("[Ptz] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Ptz] : Error when reading payload " + e.toString());
        }
    }
}

