/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.AbstractPositionDevice;
import javaclient.PlayerClient;
import javaclient.structures.PlayerPositionGeomT;

public class PositionInterface
extends AbstractPositionDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private short PLAYER_POSITION_CODE = (short)4;
    private static final short PLAYER_MSGTYPE_CMD = 2;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    protected final short PLAYER_POSITION_GET_GEOM_REQ = 1;
    protected final short PLAYER_POSITION_MOTOR_POWER_REQ = (short)2;
    protected final short PLAYER_POSITION_VELOCITY_MODE_REQ = (short)3;
    protected final short PLAYER_POSITION_RESET_ODOM_REQ = (short)4;
    protected final short PLAYER_POSITION_POSITION_MODE_REQ = (short)5;
    protected final short PLAYER_POSITION_SPEED_PID_REQ = (short)6;
    protected final short PLAYER_POSITION_POSITION_PID_REQ = (short)7;
    protected final short PLAYER_POSITION_SPEED_PROF_REQ = (short)8;
    protected final short PLAYER_POSITION_SET_ODOM_REQ = (short)9;
    protected final short PLAYER_POSITION_RMP_VELOCITY_SCALE = (short)51;
    protected final short PLAYER_POSITION_RMP_ACCEL_SCALE = (short)52;
    protected final short PLAYER_POSITION_RMP_TURN_SCALE = (short)53;
    protected final short PLAYER_POSITION_RMP_GAIN_SCHEDULE = (short)54;
    protected final short PLAYER_POSITION_RMP_CURRENT_LIMIT = (short)55;
    protected final short PLAYER_POSITION_RMP_RST_INTEGRATORS = (short)56;
    protected final short PLAYER_POSITION_RMP_SHUTDOWN = (short)57;
    protected final short PLAYER_POSITION_RMP_RST_INT_RIGHT = 1;
    protected final short PLAYER_POSITION_RMP_RST_INT_LEFT = (short)2;
    protected final short PLAYER_POSITION_RMP_RST_INT_YAW = (short)3;
    protected final short PLAYER_POSITION_RMP_RST_INT_FOREAFT = (short)4;
    private int x = 0;
    private int y = 0;
    private int yaw = 0;
    private int xSpeed = 0;
    private int ySpeed = 0;
    private int yawSpeed = 0;
    private byte stalls = 0;
    private PlayerPositionGeomT ppgt;
    private boolean readyPPGT = false;

    public PositionInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = this.PLAYER_POSITION_CODE;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        try {
            this.readHeader();
            this.x = this.is.readInt();
            this.y = this.is.readInt();
            this.yaw = this.is.readInt();
            this.xSpeed = this.is.readInt();
            this.ySpeed = this.is.readInt();
            this.yawSpeed = this.is.readInt();
            this.stalls = this.is.readByte();
        }
        catch (Exception e) {
            System.err.println("[Position] : Error when reading payload: " + e.toString());
        }
    }

    public void setPosition(int xP, int yP, int yawT, int xS, int yS, int yawS, byte state, byte type) {
        try {
            this.sendHeader((short)2, 26);
            this.os.writeInt(xP);
            this.os.writeInt(yP);
            this.os.writeInt(yawT);
            this.os.writeInt(xS);
            this.os.writeInt(yS);
            this.os.writeInt(yawS);
            this.os.writeByte(state);
            this.os.writeByte(type);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send position commands: " + e.toString());
        }
    }

    public void setPosition(int xP, int yP, int yawT) {
        this.setPosition(xP, yP, yawT, this.xSpeed, this.ySpeed, this.yawSpeed, (byte)1, (byte)1);
    }

    public void setHeading(int yawT) {
        this.setPosition(this.x, this.y, yawT, this.xSpeed, this.ySpeed, this.yawSpeed, (byte)1, (byte)1);
    }

    public void setSpeed(int speed, int turnrate) {
        this.setPosition(this.x, this.y, this.yaw, speed, this.ySpeed, turnrate, (byte)1, (byte)0);
    }

    public void setSpeed(int speed, int turnrate, int sideSpeed) {
        this.setPosition(this.x, this.y, this.yaw, speed, sideSpeed, turnrate, (byte)1, (byte)0);
    }

    public void queryGeometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.write(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_GET_GEOM_REQ command: " + e.toString());
        }
    }

    public boolean isGeomReady() {
        if (this.readyPPGT) {
            this.readyPPGT = false;
            return true;
        }
        return false;
    }

    public synchronized PlayerPositionGeomT getGeom() {
        return this.ppgt;
    }

    public synchronized int getX() {
        return this.x;
    }

    public synchronized int getY() {
        return this.y;
    }

    public synchronized int getYaw() {
        return this.yaw;
    }

    public synchronized int getXSpeed() {
        return this.xSpeed;
    }

    public synchronized int getYSpeed() {
        return this.ySpeed;
    }

    public synchronized int getYawSpeed() {
        return this.yawSpeed;
    }

    public synchronized byte getStall() {
        return this.stalls;
    }

    public void setMotorPower(int state) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(2);
            this.os.writeByte((byte)state);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_MOTOR_POWER_REQ command: " + e.toString());
        }
    }

    public void setVelocityControl(int mode) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(3);
            this.os.writeByte((byte)mode);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_VELOCITY_MODE_REQ command: " + e.toString());
        }
    }

    public void resetOdometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(4);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_RESET_ODOM_REQ command: " + e.toString());
        }
    }

    public void setControlMode(int mode) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(5);
            this.os.writeByte((byte)mode);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_POSITION_MODE_REQ command: " + e.toString());
        }
    }

    public void setOdometry(int xT, int yT, int theta) {
        try {
            this.sendHeader((short)3, 13);
            this.os.writeByte(9);
            this.os.writeInt(xT);
            this.os.writeInt(yT);
            this.os.writeInt(theta);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_SET_ODOM_REQ command: " + e.toString());
        }
    }

    public void setVelocityPIDParams(int kp, int ki, int kd) {
        try {
            this.sendHeader((short)3, 13);
            this.os.writeByte(6);
            this.os.writeInt(kp);
            this.os.writeInt(ki);
            this.os.writeInt(kd);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_SPEED_PID_REQ command: " + e.toString());
        }
    }

    public void setPositionPIDParams(int kp, int ki, int kd) {
        try {
            this.sendHeader((short)3, 13);
            this.os.writeByte(7);
            this.os.writeInt(kp);
            this.os.writeInt(ki);
            this.os.writeInt(kd);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_POSITION_PID_REQ command: " + e.toString());
        }
    }

    public void setSpeedProfileParams(short sp, short acc) {
        try {
            this.sendHeader((short)3, 5);
            this.os.writeByte(8);
            this.os.writeShort(sp);
            this.os.writeShort(acc);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send PLAYER_POSITION_SPEED_PROF_REQ command: " + e.toString());
        }
    }

    public void setSegwayRPMparams(byte subtype, short value) {
        try {
            this.sendHeader((short)3, 3);
            this.os.writeByte(subtype);
            this.os.writeShort(value);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position] : Couldn't send Segway RPM configuration request: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Position][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    this.ppgt = new PlayerPositionGeomT();
                    short[] ppose = new short[3];
                    short[] psize = new short[2];
                    ppose[0] = this.is.readShort();
                    ppose[1] = this.is.readShort();
                    ppose[2] = this.is.readShort();
                    psize[0] = (short)this.is.readUnsignedShort();
                    psize[1] = (short)this.is.readUnsignedShort();
                    this.ppgt.setPose(ppose);
                    this.ppgt.setSize(psize);
                    this.readyPPGT = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 51: {
                    break;
                }
                case 52: {
                    break;
                }
                case 53: {
                    break;
                }
                case 54: {
                    break;
                }
                case 55: {
                    break;
                }
                case 56: {
                    break;
                }
                case 57: {
                    break;
                }
                default: {
                    System.err.println("[Position] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Position] : Error when reading payload " + e.toString());
        }
    }

    public void handleNARMessage() {
        try {
            int size = this.is.readInt();
            System.err.println("[Position] : Handling NAR of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Position] : handleResponsePosition ERROR " + e.toString());
        }
    }

    public void handleEARMessage() {
        try {
            int size = this.is.readInt();
            System.err.println("[Position] : Handling EAR of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Position] : handleResponsePosition ERROR " + e.toString());
        }
    }
}

