/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.AbstractPositionDevice;
import javaclient.PlayerClient;
import javaclient.structures.PlayerPosition3DGeomT;

public class Position3DInterface
extends AbstractPositionDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_POSITION3D_CODE = (short)30;
    private static final short PLAYER_MSGTYPE_CMD = 2;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    protected final short PLAYER_POSITION3D_GET_GEOM_REQ = 1;
    protected final short PLAYER_POSITION3D_MOTOR_POWER_REQ = (short)2;
    protected final short PLAYER_POSITION3D_VELOCITY_MODE_REQ = (short)3;
    protected final short PLAYER_POSITION3D_RESET_ODOM_REQ = (short)4;
    protected final short PLAYER_POSITION3D_POSITION_MODE_REQ = (short)5;
    protected final short PLAYER_POSITION3D_SPEED_PID_REQ = (short)6;
    protected final short PLAYER_POSITION3D_POSITION_PID_REQ = (short)7;
    protected final short PLAYER_POSITION3D_SPEED_PROF_REQ = (short)8;
    protected final short PLAYER_POSITION3D_SET_ODOM_REQ = (short)9;
    private int xPos = 0;
    private int yPos = 0;
    private int zPos = 0;
    private int roll = 0;
    private int pitch = 0;
    private int yaw = 0;
    private int xSpeed = 0;
    private int ySpeed = 0;
    private int zSpeed = 0;
    private int pitchSpeed = 0;
    private int rollSpeed = 0;
    private int yawSpeed = 0;
    private byte stalls = 0;
    private PlayerPosition3DGeomT ppgt;
    private boolean readyPPGT = false;

    public Position3DInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)30;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        try {
            this.readHeader();
            this.xPos = this.is.readInt();
            this.yPos = this.is.readInt();
            this.zPos = this.is.readInt();
            this.roll = this.is.readInt();
            this.pitch = this.is.readInt();
            this.yaw = this.is.readInt();
            this.xSpeed = this.is.readInt();
            this.ySpeed = this.is.readInt();
            this.zSpeed = this.is.readInt();
            this.rollSpeed = this.is.readInt();
            this.pitchSpeed = this.is.readInt();
            this.yawSpeed = this.is.readInt();
            this.stalls = this.is.readByte();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int getX() {
        return this.xPos;
    }

    public synchronized int getY() {
        return this.yPos;
    }

    public synchronized int getZ() {
        return this.zPos;
    }

    public synchronized int getRoll() {
        return this.roll;
    }

    public synchronized int getPitch() {
        return this.pitch;
    }

    public synchronized int getYaw() {
        return this.yaw;
    }

    public synchronized int getXSpeed() {
        return this.xSpeed;
    }

    public synchronized int getYSpeed() {
        return this.ySpeed;
    }

    public synchronized int getZSpeed() {
        return this.zSpeed;
    }

    public synchronized int getRollSpeed() {
        return this.rollSpeed;
    }

    public synchronized int getPitchSpeed() {
        return this.pitchSpeed;
    }

    public synchronized int getYawSpeed() {
        return this.yawSpeed;
    }

    public synchronized byte getStall() {
        return this.stalls;
    }

    public void setPosition(int xP, int yP, int zP, int pitchP, int rollP, int yawP, int xS, int yS, int zS, int pitchS, int rollS, int yawS, byte state, byte type) {
        try {
            this.sendHeader((short)2, 50);
            this.os.writeInt(xP);
            this.os.writeInt(yP);
            this.os.writeInt(zP);
            this.os.writeInt(pitchP);
            this.os.writeInt(rollP);
            this.os.writeInt(yawP);
            this.os.writeInt(xS);
            this.os.writeInt(yS);
            this.os.writeInt(zS);
            this.os.writeInt(pitchS);
            this.os.writeInt(rollS);
            this.os.writeInt(yawS);
            this.os.writeByte(state);
            this.os.writeByte(type);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send position commands: " + e.toString());
        }
    }

    public void setPosition(int xP, int yP, int zP) {
        this.setPosition(xP, yP, zP, this.pitch, this.roll, this.yaw, this.xSpeed, this.ySpeed, this.zSpeed, this.pitchSpeed, this.rollSpeed, this.yawSpeed, (byte)1, (byte)1);
    }

    public void setPosition(int xP, int yP, int zP, int pitchP, int rollP, int yawP) {
        this.setPosition(xP, yP, zP, pitchP, rollP, yawP, this.xSpeed, this.ySpeed, this.zSpeed, this.pitchSpeed, this.rollSpeed, this.yawSpeed, (byte)1, (byte)1);
    }

    public void setSpeed(int xS, int yS) {
        this.setPosition(this.xPos, this.yPos, this.zPos, this.pitch, this.roll, this.yaw, xS, yS, this.zSpeed, this.pitchSpeed, this.rollSpeed, this.yawSpeed, (byte)1, (byte)0);
    }

    public void setSpeed(int xS, int yS, int zS) {
        this.setPosition(this.xPos, this.yPos, this.zPos, this.pitch, this.roll, this.yaw, xS, yS, zS, this.pitchSpeed, this.rollSpeed, this.yawSpeed, (byte)1, (byte)0);
    }

    public void setSpeed(int xS, int yS, int zS, int pitchS, int rollS, int yawS) {
        this.setPosition(this.xPos, this.yPos, this.zPos, this.pitch, this.roll, this.yaw, xS, yS, zS, pitchS, rollS, yawS, (byte)1, (byte)0);
    }

    public void queryGeometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.write(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_GET_GEOM_REQ command: " + e.toString());
        }
    }

    public boolean isGeomReady() {
        if (this.readyPPGT) {
            this.readyPPGT = false;
            return true;
        }
        return false;
    }

    public synchronized PlayerPosition3DGeomT getGeom() {
        return this.ppgt;
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Position2D][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    this.ppgt = new PlayerPosition3DGeomT();
                    short[] ppose = new short[6];
                    short[] psize = new short[3];
                    ppose[0] = this.is.readShort();
                    ppose[1] = this.is.readShort();
                    ppose[2] = this.is.readShort();
                    ppose[3] = this.is.readShort();
                    ppose[4] = this.is.readShort();
                    ppose[5] = this.is.readShort();
                    psize[0] = (short)this.is.readUnsignedShort();
                    psize[1] = (short)this.is.readUnsignedShort();
                    psize[2] = (short)this.is.readUnsignedShort();
                    this.ppgt.setPose(ppose);
                    this.ppgt.setSize(psize);
                    this.readyPPGT = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    System.err.println("[Position3D] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Error when reading payload " + e.toString());
        }
    }

    public void setMotorPower(int state) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(2);
            this.os.writeByte((byte)state);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_MOTOR_POWER_REQ command: " + e.toString());
        }
    }

    public void changePositionControl(byte state) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(5);
            this.os.writeByte(state);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_POSITION_MODE_REQ command: " + e.toString());
        }
    }

    public void setVelocityControl(byte value) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(3);
            this.os.writeByte(value);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_VELOCITY_MODE_REQ command: " + e.toString());
        }
    }

    public void setOdometry(int xP, int yP, int zP, int rollP, int pitchP, int yawP) {
        try {
            this.sendHeader((short)3, 25);
            this.os.writeByte(9);
            this.os.writeInt(xP);
            this.os.writeInt(yP);
            this.os.writeInt(zP);
            this.os.writeInt(rollP);
            this.os.writeInt(pitchP);
            this.os.writeInt(yawP);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_SET_ODOM_REQ command: " + e.toString());
        }
    }

    public void resetOdometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(4);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_RESET_ODOM_REQ command: " + e.toString());
        }
    }

    public void setVelocityPIDParams(int kp, int ki, int kd) {
        try {
            this.sendHeader((short)3, 13);
            this.os.writeByte(6);
            this.os.writeInt(kp);
            this.os.writeInt(ki);
            this.os.writeInt(kd);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_SPEED_PID_REQ command: " + e.toString());
        }
    }

    public void setPositionPIDParams(int kp, int ki, int kd) {
        try {
            this.sendHeader((short)3, 13);
            this.os.writeByte(7);
            this.os.writeInt(kp);
            this.os.writeInt(ki);
            this.os.writeInt(kd);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_POSITION_PID_REQ command: " + e.toString());
        }
    }

    public void setSpeedProfileParams(int sp, int acc) {
        try {
            this.sendHeader((short)3, 9);
            this.os.writeByte(8);
            this.os.writeInt(sp);
            this.os.writeInt(acc);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Position3D] : Couldn't send PLAYER_POSITION3D_SPEED_PROF_REQ command: " + e.toString());
        }
    }

    public void handleNARMessage() {
        try {
            int size = this.is.readInt();
            System.err.println("[Position3D] : Handling NAR of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Position3D] : handleResponsePosition ERROR " + e.toString());
        }
    }

    public void handleEARMessage() {
        try {
            int size = this.is.readInt();
            System.err.println("[Position3D] : Handling EAR of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Position3D] : handleResponsePosition ERROR " + e.toString());
        }
    }
}

