/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import javaclient.PlayerClient;

public abstract class PlayerDevice {
    protected final short PLAYER_STXX = (short)22648;
    protected final int PLAYER_MAX_REQREP_SIZE = 4096;
    protected final int DIFFERENCE_SYNCH_FACTOR = 10;
    protected PlayerClient pc;
    protected DataInputStream is;
    protected DataOutputStream os;
    protected int t_sec = 0;
    protected int t_usec = 0;
    protected int ts_sec = 0;
    protected int ts_usec = 0;
    protected int reserved = 0;
    protected int size = 0;
    protected short device = 0;
    protected short index = (short)-1;
    private int indSynch = 0;
    private int tmpI = 0;

    public synchronized int getTimeForDataSampled_sec() {
        return this.t_sec;
    }

    public synchronized int getTimeForDataSampled_usec() {
        return this.t_usec;
    }

    public synchronized int getTimeForDataSent_sec() {
        return this.ts_sec;
    }

    public synchronized int getTimeForDataSent_usec() {
        return this.ts_usec;
    }

    public synchronized long getTimeForDataSampled() {
        return (long)this.t_sec * 1000000L + (long)this.t_usec;
    }

    public synchronized long getTimeForDataSent() {
        return (long)this.ts_sec * 1000000L + (long)this.ts_usec;
    }

    public PlayerDevice(PlayerClient plc) {
        this.pc = plc;
        this.is = this.pc.is;
        this.os = this.pc.os;
    }

    protected synchronized void readHeader() {
        try {
            this.t_sec = this.is.readInt();
            this.t_usec = this.is.readInt();
            this.ts_sec = this.is.readInt();
            this.ts_usec = this.is.readInt();
            this.reserved = this.is.readInt();
            this.size = this.is.readInt();
        }
        catch (Exception e) {
            System.err.println("[PlayerDevice] : Error when reading header: " + e.toString());
        }
    }

    protected void sendHeader(short type, int size) {
        try {
            this.os.writeShort(22648);
            this.os.writeShort(type);
            this.os.writeShort(this.device);
            this.os.writeShort(this.index);
            this.os.writeInt(0);
            this.os.writeInt(0);
            this.os.writeInt(0);
            this.os.writeInt(0);
            this.os.writeInt(0);
            this.os.writeInt(size);
        }
        catch (Exception e) {
            System.err.println("[PlayerDevice] : Error when reading header: " + e.toString());
        }
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            for (int i = 0; i < this.size; ++i) {
                this.is.readByte();
            }
        }
        catch (Exception e) {
            System.err.println("[PlayerDevice] : Error when reading payload: " + e.toString());
        }
    }

    public void handleNARMessage() {
        System.err.println("[PlayerDevice] : Need to handle a NAR message.");
    }

    public void handleEARMessage() {
        System.err.println("[PlayerDevice] : Need to handle a EAR message.");
    }

    public void handleResponse(int size) {
        if (size == 0) {
            System.err.println("[PlayerDevice] : Unexpected response of size 0!");
            return;
        }
        System.err.println("[PlayerDevice] : General handle responce was triggered.");
    }
}

