/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.net.Socket;
import java.net.SocketException;
import javaclient.AIOInterface;
import javaclient.AudioDSPInterface;
import javaclient.AudioInterface;
import javaclient.AudioMixerInterface;
import javaclient.BlinkenlightInterface;
import javaclient.BlobfinderInterface;
import javaclient.BumperInterface;
import javaclient.CameraInterface;
import javaclient.DIOInterface;
import javaclient.EnergyInterface;
import javaclient.FiducialInterface;
import javaclient.GPSInterface;
import javaclient.GripperInterface;
import javaclient.IRInterface;
import javaclient.JoystickInterface;
import javaclient.LaserInterface;
import javaclient.LocalizeInterface;
import javaclient.LogInterface;
import javaclient.MComInterface;
import javaclient.MapInterface;
import javaclient.MotorInterface;
import javaclient.NomadInterface;
import javaclient.PlannerInterface;
import javaclient.PlayerDevice;
import javaclient.Position2DInterface;
import javaclient.Position3DInterface;
import javaclient.PositionInterface;
import javaclient.PowerInterface;
import javaclient.PtzInterface;
import javaclient.SimulationInterface;
import javaclient.SonarInterface;
import javaclient.SoundInterface;
import javaclient.SpeechInterface;
import javaclient.SpeechRecognitionInterface;
import javaclient.TruthInterface;
import javaclient.WaveformInterface;
import javaclient.WiFiInterface;
import javaclient.structures.PlayerDeviceDevlistT;
import javaclient.structures.PlayerDeviceDriverInfo;
import javaclient.structures.PlayerDeviceIdT;

public class PlayerClient
extends Thread {
    public static final boolean isDebugging = System.getProperty("PlayerClient.debug") != null;
    private static final boolean stopOnEOFException = System.getProperty("PlayerClient.stopOnEOFException") == null;
    protected static final short PLAYER_STXX = 22648;
    protected static final short PLAYER_MAX_DEVICE_STRING_LEN = 64;
    protected static final short PLAYER_PLAYER_DEVLIST_REQ = 1;
    protected static final short PLAYER_PLAYER_DRIVERINFO_REQ = 2;
    protected static final short PLAYER_PLAYER_DEV_REQ = 3;
    protected static final short PLAYER_PLAYER_DATA_REQ = 4;
    protected static final short PLAYER_PLAYER_DATAMODE_REQ = 5;
    protected static final short PLAYER_PLAYER_DATAFREQ_REQ = 6;
    protected static final short PLAYER_PLAYER_AUTH_REQ = 7;
    protected static final short PLAYER_PLAYER_NAMESERVICE_REQ = 8;
    protected static final short PLAYER_MSGTYPE_DATA = 1;
    protected static final short PLAYER_MSGTYPE_CMD = 2;
    protected static final short PLAYER_MSGTYPE_REQ = 3;
    protected static final short PLAYER_MSGTYPE_RESP_ACK = 4;
    protected static final short PLAYER_MSGTYPE_SYNCH = 5;
    protected static final short PLAYER_MSGTYPE_RESP_NACK = 6;
    protected static final short PLAYER_MSGTYPE_RESP_ERR = 7;
    protected static final short PLAYER_NULL_CODE = 256;
    protected static final short PLAYER_PLAYER_CODE = 1;
    protected static final short PLAYER_POWER_CODE = 2;
    protected static final short PLAYER_GRIPPER_CODE = 3;
    protected static final short PLAYER_POSITION_CODE = 4;
    protected static final short PLAYER_SONAR_CODE = 5;
    protected static final short PLAYER_LASER_CODE = 6;
    protected static final short PLAYER_BLOBFINDER_CODE = 7;
    protected static final short PLAYER_PTZ_CODE = 8;
    protected static final short PLAYER_AUDIO_CODE = 9;
    protected static final short PLAYER_FIDUCIAL_CODE = 10;
    protected static final short PLAYER_SPEECH_CODE = 12;
    protected static final short PLAYER_GPS_CODE = 13;
    protected static final short PLAYER_BUMPER_CODE = 14;
    protected static final short PLAYER_TRUTH_CODE = 15;
    protected static final short PLAYER_IDARTURRET_CODE = 16;
    protected static final short PLAYER_IDAR_CODE = 17;
    protected static final short PLAYER_DESCARTES_CODE = 18;
    protected static final short PLAYER_DIO_CODE = 20;
    protected static final short PLAYER_AIO_CODE = 21;
    protected static final short PLAYER_IR_CODE = 22;
    protected static final short PLAYER_WIFI_CODE = 23;
    protected static final short PLAYER_WAVEFORM_CODE = 24;
    protected static final short PLAYER_LOCALIZE_CODE = 25;
    protected static final short PLAYER_MCOM_CODE = 26;
    protected static final short PLAYER_SOUND_CODE = 27;
    protected static final short PLAYER_AUDIODSP_CODE = 28;
    protected static final short PLAYER_AUDIOMIXER_CODE = 29;
    protected static final short PLAYER_POSITION3D_CODE = 30;
    protected static final short PLAYER_SIMULATION_CODE = 31;
    protected static final short PLAYER_SERVICE_ADV_CODE = 32;
    protected static final short PLAYER_BLINKENLIGHT_CODE = 33;
    protected static final short PLAYER_NOMAD_CODE = 34;
    protected static final short PLAYER_CAMERA_CODE = 40;
    protected static final short PLAYER_MAP_CODE = 42;
    protected static final short PLAYER_PLANNER_CODE = 44;
    protected static final short PLAYER_LOG_CODE = 45;
    protected static final short PLAYER_ENERGY_CODE = 46;
    protected static final short PLAYER_MOTOR_CODE = 47;
    protected static final short PLAYER_POSITION2D_CODE = 48;
    protected static final short PLAYER_JOYSTICK_CODE = 49;
    protected static final short PLAYER_SPEECH_RECOGNITION_CODE = 50;
    protected static final short PLAYER_OPAQUE_CODE = 51;
    public static final short PLAYER_READ_MODE = 114;
    public static final short PLAYER_WRITE_MODE = 119;
    public static final short PLAYER_ALL_MODE = 97;
    public static final short PLAYER_CLOSE_MODE = 99;
    public static final short PLAYER_ERROR_MODE = 101;
    protected static int N_DEVICES = 52;
    public static int MAX_DEVICES = 10;
    protected static final short PLAYER_MAX_REQREP_SIZE = 4096;
    public static final byte PLAYER_DATAMODE_PUSH_ALL = 0;
    public static final byte PLAYER_DATAMODE_PULL_ALL = 1;
    public static final byte PLAYER_DATAMODE_PUSH_NEW = 2;
    public static final byte PLAYER_DATAMODE_PULL_NEW = 3;
    public static final byte PLAYER_DATAMODE_PUSH_ASYNC = 4;
    protected PlayerDevice[][] deviceList = new PlayerDevice[N_DEVICES][MAX_DEVICES];
    private PlayerDeviceDriverInfo pddi;
    private PlayerDeviceDevlistT pddt;
    private boolean readyPDDT = false;
    private boolean readyPDDI = false;
    private boolean receivedAuthentication = false;
    private boolean readyPortNumber = false;
    protected Socket socket;
    protected BufferedOutputStream buffer;
    public DataInputStream is;
    public DataOutputStream os;
    private int portNumber;
    private long millis;
    private int nanos;
    private boolean isThreaded;
    private PlayerDevice newpd;
    private final int DIFFERENCE_SYNCH_FACTOR = 10;
    private int index = 0;

    public PlayerClient(String serverName, int portNumber) {
        try {
            int i;
            this.socket = new Socket(serverName, portNumber);
            this.is = new DataInputStream(this.socket.getInputStream());
            this.buffer = new BufferedOutputStream(this.socket.getOutputStream(), 128);
            this.os = new DataOutputStream(new DataOutputStream(this.buffer));
            for (i = 0; i < 32; ++i) {
                char c = (char)this.is.readByte();
                System.err.print(c);
            }
            System.err.println();
            for (i = 0; i < N_DEVICES; ++i) {
                for (int j = 0; j < MAX_DEVICES; ++j) {
                    this.deviceList[i][j] = null;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Error in PlayerClient init: " + e.toString());
            System.exit(1);
        }
    }

    public void close() {
        try {
            this.os.close();
            this.buffer.close();
            this.is.close();
            this.socket.close();
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Error in PlayerClient stop: " + e.toString());
            System.exit(1);
        }
    }

    public void setNotThreaded() {
        this.isThreaded = false;
    }

    public void runThreaded(long millis, int nanos) {
        if (this.isThreaded) {
            System.err.println("[PlayerClient] : A second call for runThreaded, ignoring!");
            return;
        }
        this.millis = millis;
        this.nanos = nanos;
        this.isThreaded = true;
        this.start();
    }

    public void run() {
        try {
            while (this.isThreaded) {
                while (this.read() != 5 && this.isThreaded) {
                }
                if (this.millis < 0L) {
                    Thread.yield();
                    continue;
                }
                if (this.nanos <= 0) {
                    Thread.sleep(this.millis);
                    continue;
                }
                Thread.sleep(this.millis, this.nanos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PowerInterface requestInterfacePower(int index, char r) {
        return (PowerInterface)this.requestDeviceAccess((short)2, (short)index, r);
    }

    public GripperInterface requestInterfaceGripper(int index, char r) {
        return (GripperInterface)this.requestDeviceAccess((short)3, (short)index, r);
    }

    public PositionInterface requestInterfacePosition(int index, char r) {
        return (PositionInterface)this.requestDeviceAccess((short)4, (short)index, r);
    }

    public SonarInterface requestInterfaceSonar(int index, char r) {
        return (SonarInterface)this.requestDeviceAccess((short)5, (short)index, r);
    }

    public LaserInterface requestInterfaceLaser(int index, char r) {
        return (LaserInterface)this.requestDeviceAccess((short)6, (short)index, r);
    }

    public BlobfinderInterface requestInterfaceBlobfinder(int index, char r) {
        return (BlobfinderInterface)this.requestDeviceAccess((short)7, (short)index, r);
    }

    public PtzInterface requestInterfacePtz(int index, char r) {
        return (PtzInterface)this.requestDeviceAccess((short)8, (short)index, r);
    }

    public AudioInterface requestInterfaceAudio(int index, char r) {
        return (AudioInterface)this.requestDeviceAccess((short)9, (short)index, r);
    }

    public FiducialInterface requestInterfaceFiducial(int index, char r) {
        return (FiducialInterface)this.requestDeviceAccess((short)10, (short)index, r);
    }

    public SpeechInterface requestInterfaceSpeech(int index, char r) {
        return (SpeechInterface)this.requestDeviceAccess((short)12, (short)index, r);
    }

    public GPSInterface requestInterfaceGPS(int index, char r) {
        return (GPSInterface)this.requestDeviceAccess((short)13, (short)index, r);
    }

    public BumperInterface requestInterfaceBumper(int index, char r) {
        return (BumperInterface)this.requestDeviceAccess((short)14, (short)index, r);
    }

    public TruthInterface requestInterfaceTruth(int index, char r) {
        return (TruthInterface)this.requestDeviceAccess((short)15, (short)index, r);
    }

    public DIOInterface requestInterfaceDIO(int index, char r) {
        return (DIOInterface)this.requestDeviceAccess((short)20, (short)index, r);
    }

    public AIOInterface requestInterfaceAIO(int index, char r) {
        return (AIOInterface)this.requestDeviceAccess((short)21, (short)index, r);
    }

    public IRInterface requestInterfaceIR(int index, char r) {
        return (IRInterface)this.requestDeviceAccess((short)22, (short)index, r);
    }

    public WiFiInterface requestInterfaceWiFi(int index, char r) {
        return (WiFiInterface)this.requestDeviceAccess((short)23, (short)index, r);
    }

    public WaveformInterface requestInterfaceWaveform(int index, char r) {
        return (WaveformInterface)this.requestDeviceAccess((short)24, (short)index, r);
    }

    public LocalizeInterface requestInterfaceLocalize(int index, char r) {
        return (LocalizeInterface)this.requestDeviceAccess((short)25, (short)index, r);
    }

    public MComInterface requestInterfaceMCom(int index, char r) {
        return (MComInterface)this.requestDeviceAccess((short)26, (short)index, r);
    }

    public SoundInterface requestInterfaceSound(int index, char r) {
        return (SoundInterface)this.requestDeviceAccess((short)27, (short)index, r);
    }

    public AudioDSPInterface requestInterfaceAudioDSP(int index, char r) {
        return (AudioDSPInterface)this.requestDeviceAccess((short)28, (short)index, r);
    }

    public AudioMixerInterface requestInterfaceAudioMixer(int index, char r) {
        return (AudioMixerInterface)this.requestDeviceAccess((short)29, (short)index, r);
    }

    public Position3DInterface requestInterfacePosition3D(int index, char r) {
        return (Position3DInterface)this.requestDeviceAccess((short)30, (short)index, r);
    }

    public SimulationInterface requestInterfaceSimulation(int index, char r) {
        return (SimulationInterface)this.requestDeviceAccess((short)31, (short)index, r);
    }

    public BlinkenlightInterface requestInterfaceBlinkenlight(int index, char r) {
        return (BlinkenlightInterface)this.requestDeviceAccess((short)33, (short)index, r);
    }

    public NomadInterface requestInterfaceNomad(int index, char r) {
        return (NomadInterface)this.requestDeviceAccess((short)34, (short)index, r);
    }

    public CameraInterface requestInterfaceCamera(int index, char r) {
        return (CameraInterface)this.requestDeviceAccess((short)40, (short)index, r);
    }

    public MapInterface requestInterfaceMap(int index, char r) {
        return (MapInterface)this.requestDeviceAccess((short)42, (short)index, r);
    }

    public PlannerInterface requestInterfacePlanner(int index, char r) {
        return (PlannerInterface)this.requestDeviceAccess((short)44, (short)index, r);
    }

    public LogInterface requestInterfaceLog(int index, char r) {
        return (LogInterface)this.requestDeviceAccess((short)45, (short)index, r);
    }

    public EnergyInterface requestInterfaceEnergy(int index, char r) {
        return (EnergyInterface)this.requestDeviceAccess((short)46, (short)index, r);
    }

    public MotorInterface requestInterfaceMotor(int index, char r) {
        return (MotorInterface)this.requestDeviceAccess((short)47, (short)index, r);
    }

    public Position2DInterface requestInterfacePosition2D(int index, char r) {
        return (Position2DInterface)this.requestDeviceAccess((short)48, (short)index, r);
    }

    public JoystickInterface requestInterfaceJoystick(int index, char r) {
        return (JoystickInterface)this.requestDeviceAccess((short)49, (short)index, r);
    }

    public SpeechRecognitionInterface requestInterfaceSpeechRecognition(int index, char r) {
        return (SpeechRecognitionInterface)this.requestDeviceAccess((short)50, (short)index, r);
    }

    private void sendHeader(short type, short device, short index, int size) {
        try {
            this.os.writeShort(22648);
            this.os.writeShort(type);
            this.os.writeShort(device);
            this.os.writeShort(index);
            this.os.writeInt(0);
            this.os.writeInt(0);
            this.os.writeInt(0);
            this.os.writeInt(0);
            this.os.writeInt(0);
            this.os.writeInt(size);
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Error when reading header: " + e.toString());
        }
    }

    public void requestDeviceList() {
        try {
            this.sendHeader((short)3, (short)1, (short)0, 2);
            this.os.writeShort(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Couldn't request device list " + e.toString());
        }
    }

    public void requestDriverName(short device) {
        try {
            this.sendHeader((short)3, (short)1, (short)0, 4);
            this.os.writeShort(2);
            this.os.writeShort(device);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Couldn't request driver name " + e.toString());
        }
    }

    private PlayerDevice requestDeviceAccess(short rDevice, short index, char r) {
        if (isDebugging) {
            System.err.println("[PlayerClient][Debug] : Subscribing to " + rDevice);
        }
        try {
            this.sendHeader((short)3, (short)1, (short)0, 7);
            this.os.writeShort(3);
            this.os.writeShort(rDevice);
            this.os.writeShort(index);
            this.os.writeByte((byte)r);
            this.os.flush();
            short result = 0;
            while ((result = this.requestSatisfy()) != 4) {
                if (result != -2) continue;
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Request data error: " + e.toString());
        }
        return this.newpd;
    }

    private short requestSatisfy() {
        short type = -1;
        try {
            while (this.is.readShort() != 22648) {
                if (!isDebugging) continue;
                System.err.println("[PlayerClient][Debug] : Unrecognized header: ");
            }
            type = this.is.readShort();
            short device = this.is.readShort();
            short index = this.is.readShort();
            if (isDebugging) {
                System.err.println("[PlayerClient][Debug] : Got a message: type = " + type + " device = " + device + " index = " + index);
            }
            if (type == 1) {
                try {
                    this.deviceList[device][index].readData();
                }
                catch (NullPointerException npe) {
                    System.err.println("[PlayerClient] : Got a message: type = " + type + " device = " + device + " index = " + index);
                }
                return -1;
            }
            this.is.readInt();
            this.is.readInt();
            this.is.readInt();
            this.is.readInt();
            this.is.readInt();
            int size = this.is.readInt();
            if (type == 5) {
                for (int i = 0; i < size; ++i) {
                    this.is.readByte();
                }
                return -1;
            }
            if (type == 6) {
                this.deviceList[device][index].handleNARMessage();
            } else if (type == 7) {
                this.deviceList[device][index].handleEARMessage();
            } else {
                if (isDebugging) {
                    System.err.println("[PlayerClient][Debug] : Got responce: " + device + " size of payload: " + size);
                }
                this.is.readShort();
                short device2 = this.is.readShort();
                short index2 = this.is.readShort();
                int r = this.is.readByte();
                System.err.print("[PlayerClient] : Got response for device " + device2 + "(");
                for (int i = 0; i < 64; ++i) {
                    char c = (char)this.is.readByte();
                    if (c == '\u0000') continue;
                    System.err.print(c);
                }
                System.err.println(") with access: " + (char)r);
                if (r == 101) {
                    System.err.println("[PlayerClient] : Error was replied from the server!");
                    return -2;
                }
                this.newpd = null;
                switch (device2) {
                    case 256: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.newpd = new PowerInterface(this, index2);
                        break;
                    }
                    case 3: {
                        this.newpd = new GripperInterface(this, index2);
                        break;
                    }
                    case 4: {
                        this.newpd = new PositionInterface(this, index2);
                        break;
                    }
                    case 5: {
                        this.newpd = new SonarInterface(this, index2);
                        break;
                    }
                    case 6: {
                        this.newpd = new LaserInterface(this, index2);
                        break;
                    }
                    case 7: {
                        this.newpd = new BlobfinderInterface(this, index2);
                        break;
                    }
                    case 8: {
                        this.newpd = new PtzInterface(this, index2);
                        break;
                    }
                    case 9: {
                        this.newpd = new AudioInterface(this, index2);
                        break;
                    }
                    case 10: {
                        this.newpd = new FiducialInterface(this, index2);
                        break;
                    }
                    case 12: {
                        this.newpd = new SpeechInterface(this, index2);
                        break;
                    }
                    case 13: {
                        this.newpd = new GPSInterface(this, index2);
                        break;
                    }
                    case 14: {
                        this.newpd = new BumperInterface(this, index2);
                        break;
                    }
                    case 15: {
                        this.newpd = new TruthInterface(this, index2);
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 17: {
                        break;
                    }
                    case 18: {
                        break;
                    }
                    case 20: {
                        this.newpd = new DIOInterface(this, index2);
                        break;
                    }
                    case 21: {
                        this.newpd = new AIOInterface(this, index2);
                        break;
                    }
                    case 22: {
                        this.newpd = new IRInterface(this, index2);
                        break;
                    }
                    case 23: {
                        this.newpd = new WiFiInterface(this, index2);
                        break;
                    }
                    case 24: {
                        this.newpd = new WaveformInterface(this, index2);
                        break;
                    }
                    case 25: {
                        this.newpd = new LocalizeInterface(this, index2);
                        break;
                    }
                    case 26: {
                        this.newpd = new MComInterface(this, index2);
                        break;
                    }
                    case 27: {
                        this.newpd = new SoundInterface(this, index2);
                        break;
                    }
                    case 28: {
                        this.newpd = new AudioDSPInterface(this, index2);
                        break;
                    }
                    case 29: {
                        this.newpd = new AudioMixerInterface(this, index2);
                        break;
                    }
                    case 30: {
                        this.newpd = new Position3DInterface(this, index2);
                        break;
                    }
                    case 31: {
                        this.newpd = new SimulationInterface(this, index2);
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 33: {
                        this.newpd = new BlinkenlightInterface(this, index2);
                        break;
                    }
                    case 34: {
                        this.newpd = new NomadInterface(this, index2);
                        break;
                    }
                    case 40: {
                        this.newpd = new CameraInterface(this, index2);
                        break;
                    }
                    case 42: {
                        this.newpd = new MapInterface(this, index2);
                        break;
                    }
                    case 44: {
                        this.newpd = new PlannerInterface(this, index2);
                        break;
                    }
                    case 45: {
                        this.newpd = new LogInterface(this, index2);
                        break;
                    }
                    case 46: {
                        this.newpd = new EnergyInterface(this, index2);
                        break;
                    }
                    case 47: {
                        this.newpd = new MotorInterface(this, index2);
                        break;
                    }
                    case 48: {
                        this.newpd = new Position2DInterface(this, index2);
                        break;
                    }
                    case 49: {
                        this.newpd = new JoystickInterface(this, index2);
                        break;
                    }
                    case 50: {
                        this.newpd = new SpeechRecognitionInterface(this, index2);
                        break;
                    }
                    case 51: {
                        break;
                    }
                    default: {
                        System.err.println("[PlayerClient] : Unsupported device error! - " + device2);
                        this.newpd = null;
                        r = 101;
                    }
                }
                if (this.newpd != null) {
                    this.deviceList[device2][index2] = this.newpd;
                }
            }
        }
        catch (EOFException e) {
            System.err.println("[PlayerClient] : java.io.EOFException : Is the Player server still running?");
            if (stopOnEOFException) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Read error: " + e.toString());
            e.printStackTrace();
        }
        return type;
    }

    public void requestData() {
        try {
            this.sendHeader((short)3, (short)1, (short)0, 2);
            this.os.writeShort(4);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Couldn't request one round data " + e.toString());
        }
    }

    public void requestDataDeliveryMode(byte mode) {
        try {
            this.sendHeader((short)3, (short)1, (short)0, 3);
            this.os.writeShort(5);
            this.os.writeByte(mode);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Couldn't request change of data mode " + e.toString());
        }
    }

    public void requestDataDeliveryFrequency(short frequency) {
        try {
            this.sendHeader((short)3, (short)1, (short)0, 4);
            this.os.writeShort(6);
            this.os.writeShort(frequency);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Couldn't request change of data frequency " + e.toString());
        }
    }

    public void requestAuthentication(byte[] key) {
        try {
            int i;
            if (key.length > 32) {
                throw new Exception("[PlayerClient] : Supplied authentication key is " + key.length + " but should be <= 32 bytes");
            }
            this.sendHeader((short)3, (short)1, (short)0, 34);
            this.os.writeShort(7);
            for (i = 0; i < key.length; ++i) {
                this.os.writeByte(key[i]);
            }
            for (i = 0; i < 32 - key.length; ++i) {
                this.os.writeByte(0);
            }
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Couldn't request authentication " + e.toString());
        }
    }

    public void requestNameService(char[] name) {
        try {
            int i;
            int totalSize = 66;
            this.sendHeader((short)3, (short)1, (short)0, totalSize);
            this.os.writeShort(8);
            for (i = 0; i < name.length; ++i) {
                this.os.writeByte((byte)name[i]);
            }
            for (i = 0; i < 64 - name.length; ++i) {
                this.os.writeByte(0);
            }
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Couldn't request name service " + e.toString());
        }
    }

    public synchronized int getI() {
        return this.index;
    }

    public synchronized void incI(int increment) {
        if (Math.abs(this.index - Integer.MAX_VALUE) <= 10) {
            this.index = 0;
        }
        this.index += increment;
    }

    private short read() {
        short type = -1;
        try {
            while (this.is.readShort() != 22648) {
            }
            type = this.is.readShort();
            switch (type) {
                case 1: {
                    short device = this.is.readShort();
                    short index = this.is.readShort();
                    this.deviceList[device][index].readData();
                    break;
                }
                case 2: {
                    System.err.println("[PlayerClient] : Client shouldn't receive a cmd message!");
                    break;
                }
                case 3: {
                    System.err.println("[PlayerClient] : Client shouldn't receive a req message!");
                    break;
                }
                case 4: {
                    short device = this.is.readShort();
                    short index = this.is.readShort();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    int size = this.is.readInt();
                    if (device == 1) {
                        this.handleResponse(size);
                        break;
                    }
                    this.deviceList[device][index].handleResponse(size);
                    break;
                }
                case 5: {
                    this.is.readShort();
                    this.is.readShort();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    break;
                }
                case 6: {
                    short device = this.is.readShort();
                    short index = this.is.readShort();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.deviceList[device][index].handleNARMessage();
                    break;
                }
                case 7: {
                    short device = this.is.readShort();
                    short index = this.is.readShort();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.is.readInt();
                    this.deviceList[device][index].handleEARMessage();
                    break;
                }
                default: {
                    System.err.println("[PlayerClient] : Unknown message type received in read()");
                    break;
                }
            }
        }
        catch (EOFException e) {
            System.err.println("[PlayerClient] : java.io.EOFException : Is the Player server still running?");
            if (stopOnEOFException) {
                System.exit(1);
            }
        }
        catch (SocketException e) {
            System.err.println("[PlayerClient] : java.io.SocketException : Is the Player server still running?");
            if (stopOnEOFException) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("[PlayerClient] : Read error: " + e.toString());
            e.printStackTrace();
        }
        return type;
    }

    public void readAll() {
        if (this.isThreaded) {
            return;
        }
        while (this.read() != 5) {
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            System.err.println("[PlayerClient] : Unexpected response of size 0!");
            return;
        }
        try {
            short subtype = this.is.readShort();
            switch (subtype) {
                case 1: {
                    this.pddt = new PlayerDeviceDevlistT();
                    this.pddt.setDeviceCount(this.is.readShort());
                    PlayerDeviceIdT[] playerDevList = new PlayerDeviceIdT[this.pddt.getDeviceCount()];
                    for (int i = 0; i < this.pddt.getDeviceCount(); ++i) {
                        playerDevList[i] = new PlayerDeviceIdT();
                        playerDevList[i].setCode(this.is.readShort());
                        playerDevList[i].setIndex(this.is.readShort());
                        playerDevList[i].setPort(this.is.readShort());
                    }
                    this.pddt.setDevList(playerDevList);
                    for (int j = 0; j < size - (4 + this.pddt.getDeviceCount() * 6); ++j) {
                        this.is.readByte();
                    }
                    this.readyPDDT = true;
                    break;
                }
                case 2: {
                    this.pddi = new PlayerDeviceDriverInfo();
                    PlayerDeviceIdT pddiDevID = new PlayerDeviceIdT();
                    pddiDevID.setCode(this.is.readShort());
                    pddiDevID.setIndex(this.is.readShort());
                    pddiDevID.setPort(this.is.readShort());
                    this.pddi.setDevID(pddiDevID);
                    String pddiDriverName = new String();
                    for (int j = 0; j < size - 8; ++j) {
                        pddiDriverName = pddiDriverName + this.is.readChar();
                    }
                    this.pddi.setDriverName(pddiDriverName);
                    this.readyPDDI = true;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    this.receivedAuthentication = true;
                    break;
                }
                case 8: {
                    this.portNumber = this.is.readShort();
                    this.readyPortNumber = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PlayerDeviceDevlistT getPDDT() {
        return this.pddt;
    }

    public PlayerDeviceDriverInfo getPDDI() {
        return this.pddi;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public boolean isReadyPDDT() {
        if (this.readyPDDT) {
            this.readyPDDT = false;
            return true;
        }
        return false;
    }

    public boolean isReadyPDDI() {
        if (this.readyPDDI) {
            this.readyPDDI = false;
            return true;
        }
        return false;
    }

    public boolean isAuthenticated() {
        if (this.receivedAuthentication) {
            this.receivedAuthentication = false;
            return true;
        }
        return false;
    }

    public boolean isReadyPortNumber() {
        if (this.readyPortNumber) {
            this.readyPortNumber = false;
            return true;
        }
        return false;
    }
}

