/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.PlayerPlannerWaypointT;

public class PlannerInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_PLANNER_CODE = (short)44;
    private static final short PLAYER_MSGTYPE_CMD = 2;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    protected static final short PLAYER_PLANNER_GET_WAYPOINTS_REQ = 10;
    protected static final short PLAYER_PLANNER_ENABLE_REQ = 11;
    public static final short PLAYER_PLANNER_MAX_WAYPOINTS = 128;
    private PlayerPlannerWaypointT[] ppwt = new PlayerPlannerWaypointT[128];
    private int waypoints_count = 128;
    private boolean readyPPWT = false;
    private short valid;
    private short done;
    private int px;
    private int py;
    private int pa;
    private int gx;
    private int gy;
    private int ga;
    private int wx;
    private int wy;
    private int wa;
    private short curr_waypoint;
    private int waypointPlan_count;

    public PlannerInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)44;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.valid = (short)this.is.readUnsignedByte();
            this.done = (short)this.is.readUnsignedByte();
            this.px = this.is.readInt();
            this.py = this.is.readInt();
            this.pa = this.is.readInt();
            this.gx = this.is.readInt();
            this.gy = this.is.readInt();
            this.ga = this.is.readInt();
            this.wx = this.is.readInt();
            this.wy = this.is.readInt();
            this.wa = this.is.readInt();
            this.curr_waypoint = this.is.readShort();
            this.waypointPlan_count = this.is.readUnsignedShort();
        }
        catch (Exception e) {
            System.err.println("[Planner] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized short getValid() {
        return this.valid;
    }

    public synchronized short getDone() {
        return this.done;
    }

    public synchronized int getPx() {
        return this.px;
    }

    public synchronized int getPy() {
        return this.py;
    }

    public synchronized int getPa() {
        return this.pa;
    }

    public synchronized int getGx() {
        return this.gx;
    }

    public synchronized int getGy() {
        return this.gy;
    }

    public synchronized int getGa() {
        return this.ga;
    }

    public synchronized int getWx() {
        return this.wx;
    }

    public synchronized int getWy() {
        return this.wy;
    }

    public synchronized int getWa() {
        return this.wa;
    }

    public synchronized short getCurWaypoint() {
        return this.curr_waypoint;
    }

    public synchronized int getWaypointPlanCount() {
        return this.waypointPlan_count;
    }

    public void setGoal(int newgx, int newgy, int newga) {
        try {
            this.sendHeader((short)2, 12);
            this.os.writeInt(newgx);
            this.os.writeInt(newgy);
            this.os.writeInt(newga);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Planner] : Couldn't send set new goals command: " + e.toString());
        }
    }

    public void getWaypoints() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(10);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Planner] : Couldn't send PLAYER_PLANNER_GET_WAYPOINTS_REQ command: " + e.toString());
        }
    }

    public void setRobotMotion(byte state) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(11);
            this.os.writeByte(state);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Planner] : Couldn't send PLAYER_PLANNER_ENABLE_REQ command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Planner][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 10: {
                    this.waypoints_count = this.is.readUnsignedShort();
                    for (int i = 0; i < this.waypoints_count; ++i) {
                        this.ppwt[i] = new PlayerPlannerWaypointT();
                        this.ppwt[i].setX(this.is.readInt());
                        this.ppwt[i].setY(this.is.readInt());
                        this.ppwt[i].setA(this.is.readInt());
                    }
                    this.readyPPWT = true;
                    break;
                }
                case 11: {
                    break;
                }
                default: {
                    System.err.println("[Planner] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Planner] : Error when reading payload " + e.toString());
        }
    }

    public synchronized int getWaypointCount() {
        return this.waypoints_count;
    }

    public synchronized PlayerPlannerWaypointT getPPWT(int i) {
        return this.ppwt[i];
    }

    public synchronized PlayerPlannerWaypointT[] getAllPPWT() {
        return this.ppwt;
    }

    public synchronized boolean isReadyPPWT() {
        if (this.readyPPWT) {
            this.readyPPWT = false;
            return true;
        }
        return false;
    }
}

