/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class NomadInterface
extends PlayerDevice {
    private final short PLAYER_NOMAD_CODE = (short)34;
    private static final short PLAYER_MSGTYPE_CMD = 2;
    public static final short PLAYER_NOMAD_SONAR_COUNT = 16;
    public static final short PLAYER_NOMAD_BUMPER_COUNT = 16;
    public static final short PLAYER_NOMAD_IR_COUNT = 16;
    private int x;
    private int y;
    private int a;
    private int vel_trans;
    private int vel_steer;
    private int vel_turret;
    private int[] sonar = new int[16];
    private int[] ir = new int[16];
    private int[] bumper = new int[16];

    public NomadInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)34;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            int i;
            this.x = this.is.readInt();
            this.y = this.is.readInt();
            this.a = this.is.readInt();
            this.vel_trans = this.is.readInt();
            this.vel_steer = this.is.readInt();
            this.vel_turret = this.is.readInt();
            for (i = 0; i < 16; ++i) {
                this.sonar[i] = this.is.readUnsignedShort();
            }
            for (i = 0; i < 16; ++i) {
                this.ir[i] = this.is.readUnsignedShort();
            }
            for (i = 0; i < 16; ++i) {
                this.bumper[i] = this.is.readUnsignedShort();
            }
        }
        catch (Exception e) {
            System.err.println("[Nomad] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int getX() {
        return this.x;
    }

    public synchronized int getY() {
        return this.y;
    }

    public synchronized int getA() {
        return this.a;
    }

    public synchronized int getVelTrans() {
        return this.vel_trans;
    }

    public synchronized int getVelSteer() {
        return this.vel_steer;
    }

    public synchronized int getVelTurret() {
        return this.vel_turret;
    }

    public synchronized int[] getSonars() {
        return this.sonar;
    }

    public synchronized int[] getIRs() {
        return this.ir;
    }

    public synchronized int[] getBumpers() {
        return this.bumper;
    }

    public void setVelocities(int newveltrans, int newvelsteer, int newvelturret) {
        try {
            this.sendHeader((short)2, 12);
            this.os.writeInt(newveltrans);
            this.os.writeInt(newvelsteer);
            this.os.writeInt(newvelturret);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Nomad] : Couldn't send set new goals command: " + e.toString());
        }
    }
}

