/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class MotorInterface
extends PlayerDevice {
    private final short PLAYER_MOTOR_CODE = (short)47;
    private static final short PLAYER_MSGTYPE_CMD = 2;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    protected final short PLAYER_MOTOR_MOTOR_POWER_REQ = (short)2;
    protected final short PLAYER_MOTOR_VELOCITY_MODE_REQ = (short)3;
    protected final short PLAYER_MOTOR_RESET_ODOM_REQ = (short)4;
    protected final short PLAYER_MOTOR_POSITION_MODE_REQ = (short)5;
    protected final short PLAYER_MOTOR_SPEED_PID_REQ = (short)6;
    protected final short PLAYER_MOTOR_POSITION_PID_REQ = (short)7;
    protected final short PLAYER_MOTOR_SPEED_PROF_REQ = (short)8;
    protected final short PLAYER_MOTOR_SET_ODOM_REQ = (short)9;
    protected final short PLAYER_MOTOR_SET_GEAR_REDUCTION_REQ = (short)10;
    protected final short PLAYER_MOTOR_SET_TICS_REQ = (short)11;
    private int theta;
    private int thetaSpeed;
    private byte stall;

    public MotorInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)47;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        try {
            this.readHeader();
            this.theta = this.is.readInt();
            this.thetaSpeed = this.is.readInt();
            this.stall = this.is.readByte();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int getTheta() {
        return this.theta;
    }

    public synchronized int getThetaSpeed() {
        return this.thetaSpeed;
    }

    public synchronized int getStall() {
        return this.stall;
    }

    public void setMotor(int thetaP, int thetaS, int state, int type) {
        try {
            this.sendHeader((short)2, 10);
            this.os.writeInt(thetaP);
            this.os.writeInt(thetaS);
            this.os.writeByte((byte)state);
            this.os.writeByte((byte)type);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send position commands: " + e.toString());
        }
    }

    public void changePositionControl(byte mode) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(5);
            this.os.writeByte(mode);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send PLAYER_MOTOR_POSITION_MODE_REQ command: " + e.toString());
        }
    }

    public void setVelocityControl(byte mode) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(3);
            this.os.writeByte(mode);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send PLAYER_MOTOR_VELOCITY_MODE_REQ command: " + e.toString());
        }
    }

    public void resetOdometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(4);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send PLAYER_MOTOR_RESET_ODOM_REQ command: " + e.toString());
        }
    }

    public void setOdometry(int xT, int yT, int theta) {
        try {
            this.sendHeader((short)3, 5);
            this.os.writeByte(9);
            this.os.writeInt(theta);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send PLAYER_MOTOR_SET_ODOM_REQ command: " + e.toString());
        }
    }

    public void setVelocityPIDParams(int kp, int ki, int kd) {
        try {
            this.sendHeader((short)3, 13);
            this.os.writeByte(6);
            this.os.writeInt(kp);
            this.os.writeInt(ki);
            this.os.writeInt(kd);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send PLAYER_MOTOR_SPEED_PID_REQ command: " + e.toString());
        }
    }

    public void setMotorPIDParams(int kp, int ki, int kd) {
        try {
            this.sendHeader((short)3, 13);
            this.os.writeByte(7);
            this.os.writeInt(kp);
            this.os.writeInt(ki);
            this.os.writeInt(kd);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send PLAYER_MOTOR_POSITION_PID_REQ command: " + e.toString());
        }
    }

    public void setSpeedProfileParams(int sp, int acc) {
        try {
            this.sendHeader((short)3, 9);
            this.os.writeByte(8);
            this.os.writeInt(sp);
            this.os.writeInt(acc);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send PLAYER_MOTOR_SPEED_PROF_REQ command: " + e.toString());
        }
    }

    public void setMotorPower(int state) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(2);
            this.os.writeByte(state);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Motor] : Couldn't send PLAYER_MOTOR_MOTOR_POWER_REQ command: " + e.toString());
        }
    }

    public void handleNARMessage() {
        try {
            int size = this.is.readInt();
            System.err.println("[Motor] : Handling NAR of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Motor] : handleResponsePosition ERROR " + e.toString());
        }
    }

    public void handleEARMessage() {
        try {
            int size = this.is.readInt();
            System.err.println("[Motor] : Handling EAR of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Motor] : handleResponsePosition ERROR " + e.toString());
        }
    }
}

