/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class MapInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_MAP_CODE = (short)42;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    public static final short PLAYER_MAP_MAX_CELLS_PER_TILE = 4079;
    protected static final short PLAYER_MAP_GET_INFO_REQ = 1;
    protected static final short PLAYER_MAP_GET_DATA_REQ = 2;
    private int scale;
    private int width;
    private int height;
    private int tileCol;
    private int tileRow;
    private int tileWidth;
    private int tileHeight;
    private int[] tileData = new int[4079];

    public MapInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)42;
        this.index = indexOfDevice;
    }

    public void getMapInformation() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Map] : Couldn't send PLAYER_MAP_GET_INFO_REQ command: " + e.toString());
        }
    }

    public void getMapData(int col, int row, int width, int height) {
        try {
            this.sendHeader((short)3, 17);
            this.os.writeByte(2);
            this.os.writeInt(col);
            this.os.writeInt(row);
            this.os.writeInt(width);
            this.os.writeInt(height);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Map] : Couldn't send PLAYER_MAP_GET_DATA_REQ command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Map][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            short subtype = (short)this.is.readUnsignedByte();
            switch (subtype) {
                case 1: {
                    this.scale = this.is.readInt();
                    this.width = this.is.readInt();
                    this.height = this.is.readInt();
                    break;
                }
                case 2: {
                    this.tileCol = this.is.readInt();
                    this.tileRow = this.is.readInt();
                    this.tileWidth = this.is.readInt();
                    this.tileHeight = this.is.readInt();
                    for (int i = 0; i < 4079; ++i) {
                        this.tileData[i] = this.is.readByte();
                    }
                    break;
                }
                default: {
                    System.err.println("[Map] : Unexpected response " + subtype + " of size = " + size);
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Map] : Error when reading payload " + e.toString());
        }
    }

    public synchronized int getScale() {
        return this.scale;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized int getTileCol() {
        return this.tileCol;
    }

    public synchronized int getTileRow() {
        return this.tileRow;
    }

    public synchronized int getTileWidth() {
        return this.tileWidth;
    }

    public synchronized int getTileHeight() {
        return this.tileHeight;
    }

    public synchronized int[] getTileData() {
        return this.tileData;
    }

    public void handleNARMessage() {
        try {
            int size = this.is.readInt();
            System.err.println("[Map] : Handling NAR of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Map] : handleResponsePosition ERROR " + e.toString());
        }
    }
}

