/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class MComInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_MCOM_CODE = (short)26;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    public static final short MCOM_DATA_LEN = 128;
    public static final short MCOM_N_BUFS = 10;
    public static final short MCOM_CHANNEL_LEN = 8;
    public static final String MCOM_EMPTY_STRING = "(EMPTY)";
    protected static final short MCOM_COMMAND_BUFFER_SIZE = 111;
    protected static final short MCOM_DATA_BUFFER_SIZE = 0;
    public static final short PLAYER_MCOM_PUSH_REQ = 0;
    public static final short PLAYER_MCOM_POP_REQ = 1;
    public static final short PLAYER_MCOM_READ_REQ = 2;
    public static final short PLAYER_MCOM_CLEAR_REQ = 3;
    public static final short PLAYER_MCOM_SET_CAPACITY_REQ = 4;
    private char full;
    private char[] data = new char[128];
    private short dataType;
    private char[] channelName = new char[8];
    private char fullF;
    private char[] dataF = new char[128];
    private boolean readyData = false;

    public MComInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)26;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.full = this.is.readChar();
            for (int i = 0; i < 128; ++i) {
                this.data[i] = this.is.readChar();
            }
        }
        catch (Exception e) {
            System.err.println("[MCom] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized char getFlag() {
        return this.full;
    }

    public synchronized char[] getData() {
        return this.data;
    }

    public void sendConfigReq(int whichReq, int type, String channel, boolean fullT, char[] dataT) {
        try {
            int i;
            int total = 140;
            this.sendHeader((short)3, total);
            this.os.writeByte(whichReq);
            this.os.writeShort((short)type);
            int size = channel.length();
            if (size > 8) {
                size = 8;
            }
            for (i = 0; i < size; ++i) {
                this.os.writeChar(channel.toCharArray()[i]);
            }
            if (size < 8) {
                for (i = 0; i < 8 - size; ++i) {
                    this.os.writeChar(0);
                }
            }
            this.os.writeBoolean(fullT);
            for (i = 0; i < 128; ++i) {
                this.os.writeChar(dataT[i]);
            }
            this.os.flush();
        }
        catch (Exception e) {
            String subtype = "";
            switch (type) {
                case 0: {
                    subtype = "PLAYER_MCOM_PUSH_REQ";
                    break;
                }
                case 1: {
                    subtype = "PLAYER_MCOM_POP_REQ";
                    break;
                }
                case 2: {
                    subtype = "PLAYER_MCOM_READ_REQ";
                    break;
                }
                case 3: {
                    subtype = "PLAYER_MCOM_CLEAR_REQ";
                    break;
                }
                case 4: {
                    subtype = "PLAYER_MCOM_SET_CAPACITY_REQ";
                    break;
                }
                default: {
                    System.err.println("[MCom] : Couldn't send " + subtype + " command: " + e.toString());
                }
            }
        }
    }

    public void Push(int type, String channel, char[] dataT) {
        this.sendConfigReq(0, type, channel, true, dataT);
    }

    public void Pop(int type, String channel) {
        char[] dataT = new char[128];
        this.sendConfigReq(1, type, channel, false, dataT);
    }

    public void Read(int type, String channel) {
        char[] dataT = new char[128];
        this.sendConfigReq(2, type, channel, false, dataT);
    }

    public void Clear(int type, String channel) {
        char[] dataT = new char[128];
        this.sendConfigReq(3, type, channel, false, dataT);
    }

    public void setCapacity(int type, String channel, char capacity) {
        char[] dataT = new char[128];
        dataT[0] = capacity;
        this.sendConfigReq(4, type, channel, false, dataT);
    }

    public boolean isDataReady() {
        if (this.readyData) {
            this.readyData = false;
            return true;
        }
        return false;
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[MCom][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 0: {
                    break;
                }
                case 1: {
                    int i;
                    this.dataType = (short)this.is.readUnsignedShort();
                    for (i = 0; i < 8; ++i) {
                        this.channelName[i] = this.is.readChar();
                    }
                    this.fullF = this.is.readChar();
                    for (i = 0; i < 128; ++i) {
                        this.dataF[i] = this.is.readChar();
                    }
                    this.readyData = true;
                    break;
                }
                case 2: {
                    int i;
                    this.dataType = (short)this.is.readUnsignedShort();
                    for (i = 0; i < 8; ++i) {
                        this.channelName[i] = this.is.readChar();
                    }
                    this.fullF = this.is.readChar();
                    for (i = 0; i < 128; ++i) {
                        this.dataF[i] = this.is.readChar();
                    }
                    this.readyData = true;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    System.err.println("[MCom] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[MCom] : Error when reading payload " + e.toString());
        }
    }

    public synchronized char getRFlag() {
        return this.fullF;
    }

    public synchronized char[] getRData() {
        return this.dataF;
    }

    public synchronized short getDataType() {
        return this.dataType;
    }

    public synchronized char[] getChannelName() {
        return this.channelName;
    }
}

