/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class LogInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_LOG_CODE = (short)45;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    protected static final short PLAYER_LOG_SET_WRITE_STATE_REQ = 1;
    protected static final short PLAYER_LOG_SET_READ_STATE_REQ = 2;
    protected static final short PLAYER_LOG_GET_STATE_REQ = 3;
    protected static final short PLAYER_LOG_SET_READ_REWIND_REQ = 4;
    protected static final short PLAYER_LOG_SET_FILENAME = 5;
    protected static final short PLAYER_LOG_TYPE_READ = 1;
    protected static final short PLAYER_LOG_TYPE_WRITE = 2;
    private byte state;
    private byte type;
    private boolean readyState = false;

    public LogInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)45;
        this.index = indexOfDevice;
    }

    public void setLoggingState(int state) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(1);
            this.os.writeByte((byte)state);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Log] : Couldn't send PLAYER_LOG_SET_WRITE_STATE_REQ command: " + e.toString());
        }
    }

    public void setPlaybackState(int state) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(2);
            this.os.writeByte((byte)state);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Log] : Couldn't send PLAYER_LOG_SET_READ_STATE_REQ command: " + e.toString());
        }
    }

    public void rewindPlayback() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(4);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Log] : Couldn't send PLAYER_LOG_SET_READ_REWIND_REQ command: " + e.toString());
        }
    }

    public void readState() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(3);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Log] : Couldn't send PLAYER_LOG_GET_STATE_REQ command: " + e.toString());
        }
    }

    public void setFileName(String fileName) {
        if (fileName.length() > 255) {
            fileName = fileName.substring(0, 255);
        }
        try {
            int size = 2 + fileName.length();
            this.sendHeader((short)3, size);
            this.os.writeByte(5);
            for (int i = 0; i < fileName.length(); ++i) {
                this.os.writeByte(fileName.toCharArray()[i]);
            }
            this.os.writeByte(0);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Log] : Couldn't send PLAYER_LOG_SET_FILENAME command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Log][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.type = this.is.readByte();
                    this.state = this.is.readByte();
                    this.readyState = true;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    System.err.println("[Log] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Log] : Error when reading payload " + e.toString());
        }
    }

    public byte getType() {
        return this.type;
    }

    public byte getState() {
        return this.state;
    }

    public boolean isStateReady() {
        if (this.readyState) {
            this.readyState = false;
            return true;
        }
        return false;
    }
}

