/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.Hypothesis;
import javaclient.structures.PlayerLocalizeConfigT;

public class LocalizeInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_LOCALIZE_CODE = (short)25;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    public final short PLAYER_LOCALIZE_MAX_HYPOTHS = (short)10;
    protected final short PLAYER_LOCALIZE_SET_POSE_REQ = 1;
    protected final short PLAYER_LOCALIZE_GET_CONFIG_REQ = (short)2;
    protected final short PLAYER_LOCALIZE_SET_CONFIG_REQ = (short)3;
    private short pendingCount = 0;
    private int pendingTimeSec = 0;
    private int pendingTimeuSec = 0;
    private int hypothCount = 0;
    private Hypothesis[] hypoths = new Hypothesis[10];
    private PlayerLocalizeConfigT plct = new PlayerLocalizeConfigT();
    private boolean readyPLCT = false;

    public LocalizeInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)25;
        this.index = indexOfDevice;
    }

    public int getHypothCount() {
        return this.hypothCount;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.pendingCount = (short)this.is.readUnsignedShort();
            this.pendingTimeSec = this.is.readInt();
            this.pendingTimeuSec = this.is.readInt();
            this.hypothCount = this.is.readInt();
            for (int i = 0; i < this.hypothCount; ++i) {
                this.hypoths[i] = new Hypothesis();
                int[] localizeMean = new int[3];
                for (int j = 0; j < 3; ++j) {
                    localizeMean[j] = this.is.readInt();
                }
                this.hypoths[i].setMean(localizeMean);
                long[][] localizeCov = new long[3][3];
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        localizeCov[j][k] = this.is.readLong();
                    }
                }
                this.hypoths[i].setCov(localizeCov);
                this.hypoths[i].setAlpha(this.is.readInt());
            }
        }
        catch (Exception e) {
            System.err.println("[Localize] : Error when reading payload: " + e.toString());
        }
    }

    public void setPose(int[] mean, long[][] cov) {
        try {
            int i;
            this.sendHeader((short)3, 85);
            this.os.writeByte(1);
            for (i = 0; i < 3; ++i) {
                this.os.writeInt(mean[i]);
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.os.writeLong(cov[i][j]);
                }
            }
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Localize] : Couldn't send PLAYER_LOCALIZE_SET_POSE_REQ command: " + e.toString());
        }
    }

    public void getConfiguration() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(2);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Localize] : Couldn't send PLAYER_LOCALIZE_GET_CONFIG_REQ command: " + e.toString());
        }
    }

    public void setConfiguration(int numParticles) {
        try {
            this.sendHeader((short)3, 5);
            this.os.writeByte(3);
            this.os.writeInt(numParticles);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Localize] : Couldn't send PLAYER_LOCALIZE_GET_CONFIG_REQ command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Localize][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    break;
                }
                case 2: {
                    this.plct = new PlayerLocalizeConfigT();
                    this.plct.setNumParticles(this.is.readInt());
                    this.readyPLCT = true;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    System.err.println("[Localize] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Localize] : Error when reading payload " + e.toString());
        }
    }

    public boolean isPLCTReady() {
        if (this.readyPLCT) {
            this.readyPLCT = false;
            return true;
        }
        return false;
    }

    public PlayerLocalizeConfigT getPLCT() {
        return this.plct;
    }
}

