/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.PlayerLaserConfigT;
import javaclient.structures.PlayerLaserGeomT;

public class LaserInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private short PLAYER_LASER_CODE = (short)6;
    private final short PLAYER_MSGTYPE_REQ = (short)3;
    protected final short PLAYER_LASER_GET_GEOM = 1;
    protected final short PLAYER_LASER_SET_CONFIG = (short)2;
    protected final short PLAYER_LASER_GET_CONFIG = (short)3;
    protected final short PLAYER_LASER_POWER_CONFIG = (short)4;
    public final int PLAYER_LASER_MAX_SAMPLES = 401;
    private short minAngle = 0;
    private short maxAngle = 0;
    private int resolution = 0;
    private int rangeRes = 0;
    private int samplesCount = 0;
    private int[] range = new int[401];
    private int[] intensity = new int[401];
    private boolean newInfo = false;
    private PlayerLaserGeomT plgt;
    private boolean readyPLGT;
    private PlayerLaserConfigT plct;
    private boolean readyPLCT;

    public LaserInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = this.PLAYER_LASER_CODE;
        this.index = indexOfDevice;
        for (int i = 0; i < this.range.length; ++i) {
            this.range[i] = 0;
            this.intensity[i] = 0;
        }
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            int i;
            this.minAngle = this.is.readShort();
            this.maxAngle = this.is.readShort();
            this.resolution = this.is.readUnsignedShort();
            this.rangeRes = this.is.readUnsignedShort();
            this.samplesCount = this.is.readUnsignedShort();
            for (i = 0; i < 401; ++i) {
                this.range[i] = this.is.readUnsignedShort();
            }
            for (i = 0; i < 401; ++i) {
                this.intensity[i] = this.is.readUnsignedByte();
            }
        }
        catch (Exception e) {
            System.err.println("[Laser] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized short getMinAngle() {
        return this.minAngle;
    }

    public synchronized short getMaxAngle() {
        return this.maxAngle;
    }

    public synchronized int getResolution() {
        return this.resolution;
    }

    public synchronized int getRangeRes() {
        return this.rangeRes;
    }

    public synchronized int getSamplesCount() {
        return this.samplesCount;
    }

    public synchronized int[] getRanges() {
        return this.range;
    }

    public synchronized int[] getIntensity() {
        return this.intensity;
    }

    public void getGeometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Laser] : Couldn't send PLAYER_LASER_GET_GEOM command: " + e.toString());
        }
    }

    public void setScanProperties(short minA, short maxA, short res, short range, byte intent) {
        try {
            this.sendHeader((short)3, 10);
            this.os.writeByte(2);
            this.os.writeShort(minA);
            this.os.writeShort(maxA);
            this.os.writeShort(res);
            this.os.writeShort(range);
            this.os.writeByte(intent);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Laser] : Couldn't send PLAYER_LASER_SET_CONFIG command: " + e.toString());
        }
    }

    public void getScanProperties() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(3);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Laser] : Couldn't send PLAYER_LASER_GET_CONFIG command: " + e.toString());
        }
    }

    public void setPower(byte value) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(4);
            this.os.writeByte(value);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Laser] : Couldn't send PLAYER_LASER_POWER_CONFIG command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Laser][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            short subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    this.plgt = new PlayerLaserGeomT();
                    short[] laserPose = new short[2];
                    short[] laserSize = new short[3];
                    laserPose[0] = this.is.readShort();
                    laserPose[1] = this.is.readShort();
                    laserPose[2] = this.is.readShort();
                    laserSize[0] = this.is.readShort();
                    laserSize[1] = this.is.readShort();
                    this.plgt.setPose(laserPose);
                    this.plgt.setSize(laserSize);
                    this.readyPLGT = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.plct = new PlayerLaserConfigT();
                    this.plct.setMinAngle(this.is.readShort());
                    this.plct.setMaxAngle(this.is.readShort());
                    this.plct.setResolution(this.is.readUnsignedShort());
                    this.plct.setRangeRes(this.is.readUnsignedShort());
                    this.plct.setIntensity(this.is.readByte());
                    this.readyPLCT = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    System.err.println("[Laser] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Laser] : Error when reading payload " + e.toString());
        }
    }

    public PlayerLaserGeomT getPlayerLaserGeom() {
        return this.plgt;
    }

    public PlayerLaserConfigT getPlayerLaserConfig() {
        return this.plct;
    }

    public boolean isReadyPLGT() {
        if (this.readyPLGT) {
            this.readyPLGT = false;
            return true;
        }
        return false;
    }

    public boolean isReadyPLCT() {
        if (this.readyPLCT) {
            this.readyPLCT = false;
            return true;
        }
        return false;
    }
}

