/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.PlayerIRPoseReqT;

public class IRInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_IR_CODE = (short)22;
    public static final short PLAYER_IR_MAX_SAMPLES = 32;
    protected final short PLAYER_IR_POSE_REQ = 1;
    protected final short PLAYER_IR_POWER_REQ = (short)2;
    private final short PLAYER_MSGTYPE_REQ = (short)3;
    private int rangeCount;
    private int[] voltages = new int[32];
    private int[] ranges = new int[32];
    private PlayerIRPoseReqT piprt;
    private boolean readyPIPRT = false;

    public IRInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)22;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            int i;
            this.rangeCount = this.is.readUnsignedShort();
            for (i = 0; i < 32; ++i) {
                this.voltages[i] = this.is.readUnsignedShort();
            }
            for (i = 0; i < 32; ++i) {
                this.ranges[i] = this.is.readUnsignedShort();
            }
        }
        catch (Exception e) {
            System.err.println("[IR] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int[] getVoltages() {
        return this.voltages;
    }

    public synchronized int[] getRanges() {
        return this.ranges;
    }

    public synchronized int getRangeCount() {
        return this.rangeCount;
    }

    public void queryPose() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[IR] : Couldn't send PLAYER_IR_POSE_REQ command: " + e.toString());
        }
    }

    public void setIRPower(int value) {
        try {
            this.sendHeader((short)3, 2);
            this.os.writeByte(2);
            this.os.writeByte((byte)value);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[IR] : Couldn't send PLAYER_IR_POWER_REQ command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[IR][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    this.piprt = new PlayerIRPoseReqT();
                    this.piprt.setPoseCount(this.is.readShort());
                    short[][] IRPoses = new short[32][3];
                    for (int i = 0; i < 32; ++i) {
                        IRPoses[i][0] = this.is.readShort();
                        IRPoses[i][1] = this.is.readShort();
                        IRPoses[i][2] = this.is.readShort();
                    }
                    this.piprt.setPoses(IRPoses);
                    this.readyPIPRT = true;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    System.err.println("[IR] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[IR] : Error when reading payload " + e.toString());
        }
    }

    public boolean isPIPRTReady() {
        if (this.readyPIPRT) {
            this.readyPIPRT = false;
            return true;
        }
        return false;
    }

    public PlayerIRPoseReqT getPIPRT() {
        return this.piprt;
    }
}

