/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class GripperInterface
extends PlayerDevice {
    private final short PLAYER_GRIPPER_CODE = (short)3;
    private final short PLAYER_MSGTYPE_CMD = (short)2;
    private byte state;
    private byte beams;

    public GripperInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)3;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        try {
            this.readHeader();
            this.state = this.is.readByte();
            this.beams = this.is.readByte();
        }
        catch (Exception e) {
            System.err.println("[Gripper] : Error when reading payload: " + e.toString());
        }
    }

    public void setGripper(int cmd, int arg) {
        try {
            this.sendHeader((short)2, 2);
            this.os.writeByte((byte)cmd);
            this.os.writeByte((byte)arg);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Gripper] : Couldn't send gripper command request: " + e.toString());
        }
    }

    public synchronized byte getState() {
        return this.state;
    }

    public synchronized byte getBeams() {
        return this.beams;
    }
}

