/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class GPSInterface
extends PlayerDevice {
    private short PLAYER_GPS_CODE = (short)13;
    private int timeSec = 0;
    private int timeuSec = 0;
    private int latitude = 0;
    private int longitude = 0;
    private int altitude = 0;
    private int utmE = 0;
    private int utmN = 0;
    private byte quality = 0;
    private byte numSats = 0;
    private short hDop = 0;
    private short vDop = 0;
    private int errHorz = 0;
    private int errVert = 0;

    public GPSInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = this.PLAYER_GPS_CODE;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        try {
            this.readHeader();
            this.timeSec = this.is.readInt();
            this.timeuSec = this.is.readInt();
            this.latitude = this.is.readInt();
            this.longitude = this.is.readInt();
            this.altitude = this.is.readInt();
            this.utmE = this.is.readInt();
            this.utmN = this.is.readInt();
            this.quality = (byte)this.is.readUnsignedByte();
            this.numSats = (byte)this.is.readUnsignedByte();
            this.hDop = (short)this.is.readUnsignedShort();
            this.vDop = (short)this.is.readUnsignedShort();
            this.errHorz = this.is.readInt();
            this.errVert = this.is.readInt();
        }
        catch (Exception e) {
            System.err.println("[GPS] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int getTimeSec() {
        return this.timeSec;
    }

    public synchronized int getTimeuSec() {
        return this.timeuSec;
    }

    public synchronized int getLatitude() {
        return this.latitude;
    }

    public synchronized int getLongitude() {
        return this.longitude;
    }

    public synchronized int getAltitude() {
        return this.altitude;
    }

    public synchronized int getUtmE() {
        return this.utmE;
    }

    public synchronized int getUtmN() {
        return this.utmN;
    }

    public synchronized byte getQuality() {
        return this.quality;
    }

    public synchronized byte getNumSats() {
        return this.numSats;
    }

    public synchronized short getHDop() {
        return this.hDop;
    }

    public synchronized short getVDop() {
        return this.vDop;
    }

    public synchronized int getErrHorz() {
        return this.errHorz;
    }

    public synchronized int getErrVert() {
        return this.errVert;
    }
}

