/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.PlayerFiducialItem;

public class FiducialInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_FIDUCIAL_CODE = (short)10;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    public static final short PLAYER_FIDUCIAL_MAX_SAMPLES = 32;
    public static final short PLAYER_FIDUCIAL_MAX_MSG_LEN = 32;
    protected final short PLAYER_FIDUCIAL_GET_GEOM = 1;
    protected final short PLAYER_FIDUCIAL_GET_FOV = (short)2;
    protected final short PLAYER_FIDUCIAL_SET_FOV = (short)3;
    protected final short PLAYER_FIDUCIAL_SEND_MSG = (short)4;
    protected final short PLAYER_FIDUCIAL_RECV_MSG = (short)5;
    protected final short PLAYER_FIDUCIAL_EXCHANGE_MSG = (short)6;
    protected final short PLAYER_FIDUCIAL_GET_ID = (short)7;
    protected final short PLAYER_FIDUCIAL_SET_ID = (short)8;
    private int count;
    private PlayerFiducialItem[] fiducials = new PlayerFiducialItem[32];
    private int[] detectPose = new int[3];
    private int[] detectSize = new int[2];
    private int[] fiducial_size = new int[2];
    private boolean geometryReady;
    private boolean fovReady;
    private boolean idReady;
    private int minRange;
    private int maxRange;
    private int viewAngle;
    private int id;

    public FiducialInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)10;
        this.index = indexOfDevice;
        for (int i = 0; i < this.fiducials.length; ++i) {
            this.fiducials[i] = new PlayerFiducialItem();
        }
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.count = this.is.readUnsignedShort();
            for (int i = 0; i < this.count; ++i) {
                this.fiducials[i].setID(this.is.readShort());
                int[] pos = new int[3];
                for (int j = 0; j < 3; ++j) {
                    pos[j] = this.is.readInt();
                }
                this.fiducials[i].setPos(pos);
                int[] rot = new int[3];
                for (int j = 0; j < 3; ++j) {
                    rot[j] = this.is.readInt();
                }
                this.fiducials[i].setRot(rot);
                int[] upos = new int[3];
                for (int j = 0; j < 3; ++j) {
                    upos[j] = this.is.readInt();
                }
                this.fiducials[i].setUPos(upos);
                int[] urot = new int[3];
                for (int j = 0; j < 3; ++j) {
                    urot[j] = this.is.readInt();
                }
                this.fiducials[i].setURot(urot);
            }
        }
        catch (Exception e) {
            System.err.println("[Fiducial] : Error when reading payload: " + e.toString());
        }
    }

    public void getGeometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Fiducial] : Couldn't send PLAYER_FIDUCIAL_GET_GEOM command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Fiducial][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.detectPose[i] = this.is.readShort();
                    }
                    for (i = 0; i < 2; ++i) {
                        this.detectSize[i] = this.is.readUnsignedShort();
                    }
                    for (i = 0; i < 2; ++i) {
                        this.fiducial_size[i] = this.is.readUnsignedShort();
                    }
                    this.geometryReady = true;
                    break;
                }
                case 2: {
                    this.minRange = this.is.readUnsignedShort();
                    this.maxRange = this.is.readUnsignedShort();
                    this.viewAngle = this.is.readUnsignedShort();
                    this.fovReady = true;
                    break;
                }
                case 3: {
                    break;
                }
                case 7: {
                    this.id = this.is.readInt();
                    this.idReady = true;
                    break;
                }
                default: {
                    System.err.println("[Fiducial] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Fiducial] : Error when reading payload " + e.toString());
        }
    }

    public boolean isGeomReady() {
        if (this.geometryReady) {
            this.geometryReady = false;
            return true;
        }
        return false;
    }

    public synchronized int[] getDetectPose() {
        return this.detectPose;
    }

    public synchronized int[] getDetectSize() {
        return this.detectSize;
    }

    public synchronized int[] getFiducialSize() {
        return this.fiducial_size;
    }

    public void getFOV() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(2);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Fiducial] : Couldn't send PLAYER_FIDUCIAL_GET_FOV command: " + e.toString());
        }
    }

    public boolean isFOVReady() {
        if (this.fovReady) {
            this.fovReady = false;
            return true;
        }
        return false;
    }

    public synchronized int getMinRange() {
        return this.minRange;
    }

    public synchronized int getMaxRange() {
        return this.maxRange;
    }

    public synchronized int getViewAngle() {
        return this.viewAngle;
    }

    public void setFOV(int newMinRange, int newMaxRange, int newViewAngle) {
        try {
            this.sendHeader((short)3, 7);
            this.os.writeByte(3);
            this.os.writeShort(newMinRange);
            this.os.writeShort(newMaxRange);
            this.os.writeShort(newViewAngle);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Fiducial] : Couldn't send PLAYER_FIDUCIAL_SET_FOV command: " + e.toString());
        }
    }

    public void getFiducialVal() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(7);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Fiducial] : Couldn't send PLAYER_FIDUCIAL_GET_ID command: " + e.toString());
        }
    }

    public boolean isIDReady() {
        if (this.idReady) {
            this.idReady = false;
            return true;
        }
        return false;
    }

    public synchronized int getID() {
        return this.id;
    }

    public void setFiducialVal(int newID) {
        try {
            this.sendHeader((short)3, 5);
            this.os.writeByte(8);
            this.os.writeInt(newID);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Fiducial] : Couldn't send PLAYER_FIDUCIAL_SET_ID command: " + e.toString());
        }
    }

    public int getFiducialCount() {
        return this.count;
    }

    public PlayerFiducialItem[] getFiducials() {
        return this.fiducials;
    }
}

