/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class CameraInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_CAMERA_CODE = (short)40;
    public static final short PLAYER_CAMERA_IMAGE_WIDTH = 640;
    public static final short PLAYER_CAMERA_IMAGE_HEIGHT = 480;
    public static final int PLAYER_CAMERA_IMAGE_SIZE = 1228800;
    public static final short PLAYER_CAMERA_FORMAT_MONO8 = 1;
    public static final short PLAYER_CAMERA_FORMAT_MONO16 = 2;
    public static final short PLAYER_CAMERA_FORMAT_RGB565 = 4;
    public static final short PLAYER_CAMERA_FORMAT_RGB888 = 5;
    public static final short PLAYER_CAMERA_COMPRESS_RAW = 0;
    public static final short PLAYER_CAMERA_COMPRESS_JPEG = 1;
    private short width;
    private short height;
    private byte bpp;
    private byte format;
    private short fdiv;
    private byte compression;
    private int image_size;
    private byte[] image = new byte[1228800];

    public CameraInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)40;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.width = (short)this.is.readUnsignedShort();
            this.height = (short)this.is.readUnsignedShort();
            this.bpp = (byte)this.is.readUnsignedByte();
            this.format = (byte)this.is.readUnsignedByte();
            this.fdiv = (short)this.is.readUnsignedShort();
            this.compression = (byte)this.is.readUnsignedByte();
            this.image_size = this.is.readInt();
            for (int i = 0; i < 1228800; ++i) {
                this.image[i] = (byte)this.is.readUnsignedByte();
            }
        }
        catch (Exception e) {
            System.err.println("[Camera] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized short getWidth() {
        return this.width;
    }

    public synchronized short getHeight() {
        return this.height;
    }

    public synchronized byte getBPP() {
        return this.bpp;
    }

    public synchronized byte getFormat() {
        return this.format;
    }

    public synchronized short getFDiv() {
        return this.fdiv;
    }

    public synchronized byte getCompression() {
        return this.compression;
    }

    public synchronized int getImageSize() {
        return this.image_size;
    }

    public synchronized byte[] getImage() {
        return this.image;
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Camera][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                default: 
            }
            System.err.println("[Camera] : Unexpected response " + subtype + " of size = " + size);
        }
        catch (Exception e) {
            System.err.println("[Camera] : Error when reading payload " + e.toString());
        }
    }
}

