/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.PlayerBumperDefineT;
import javaclient.structures.PlayerBumperGeomT;

public class BumperInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_BUMPER_CODE = (short)14;
    private final short PLAYER_MSGTYPE_REQ = (short)3;
    public static final int PLAYER_BUMPER_MAX_SAMPLES = 32;
    protected final short PLAYER_BUMPER_GET_GEOM_REQ = 1;
    private byte bumperCount = (byte)32;
    private byte[] bumpers = new byte[32];
    private PlayerBumperGeomT pbgt;
    private boolean readyPBGT = false;

    public BumperInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)14;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        try {
            this.readHeader();
            this.bumperCount = this.is.readByte();
            for (int i = 0; i < this.bumperCount; ++i) {
                this.bumpers[i] = this.is.readByte();
            }
        }
        catch (Exception e) {
            System.err.println("[Bumper] : Error when reading payload: " + e.toString());
        }
    }

    public void queryGeometry() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(1);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Bumper] : Couldn't send PLAYER_BUMPER_GET_GEOM_REQ command: " + e.toString());
        }
    }

    public synchronized byte[] getBumpers() {
        return this.bumpers;
    }

    public synchronized byte getBumperCount() {
        return this.bumperCount;
    }

    public PlayerBumperGeomT getPlayerBumperGeom() {
        return this.pbgt;
    }

    public boolean isGeomReady() {
        if (this.readyPBGT) {
            this.readyPBGT = false;
            return true;
        }
        return false;
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Bumper][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            short subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    this.pbgt = new PlayerBumperGeomT();
                    this.readyPBGT = true;
                    this.pbgt.setBumperCount(this.is.readShort());
                    PlayerBumperDefineT[] pbgtData = new PlayerBumperDefineT[32];
                    for (int i = 0; i < 32; ++i) {
                        pbgtData[i].setXOffset(this.is.readShort());
                        pbgtData[i].setYOffset(this.is.readShort());
                        pbgtData[i].setThOffset(this.is.readShort());
                        pbgtData[i].setLength(this.is.readShort());
                        pbgtData[i].setRadius(this.is.readShort());
                    }
                    this.pbgt.setData(pbgtData);
                    break;
                }
                default: {
                    System.err.println("[Bumper] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Bumper] : Error when reading payload " + e.toString());
        }
    }
}

