/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;
import javaclient.structures.Blob;

public class BlobfinderInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_BLOBFINDER_CODE = (short)7;
    public final short PLAYER_BLOBFINDER_MAX_BLOBS = (short)256;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    private final short PLAYER_BLOBFINDER_SET_COLOR_REQ = 1;
    private final short PLAYER_BLOBFINDER_SET_IMAGER_PARAMS_REQ = (short)2;
    private short imageWidth;
    private short imageHeight;
    private short blobCount = 0;
    private Blob[] blobList = new Blob[256];

    public BlobfinderInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)7;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            this.imageWidth = this.is.readShort();
            this.imageHeight = this.is.readShort();
            this.blobCount = this.is.readShort();
            for (int i = 0; i < this.blobCount; ++i) {
                this.blobList[i] = new Blob();
                this.blobList[i].setID(this.is.readShort());
                this.blobList[i].setColor(this.is.readInt());
                this.blobList[i].setArea(this.is.readInt());
                this.blobList[i].setX(this.is.readShort());
                this.blobList[i].setY(this.is.readShort());
                this.blobList[i].setLeft(this.is.readShort());
                this.blobList[i].setRight(this.is.readShort());
                this.blobList[i].setTop(this.is.readShort());
                this.blobList[i].setBottom(this.is.readShort());
                this.blobList[i].setRange(this.is.readShort());
            }
        }
        catch (Exception e) {
            System.err.println("[Blobfinder] : Error when reading payload: " + e.toString());
        }
    }

    public void setTrackingColor(int rmin, int rmax, int gmin, int gmax, int bmin, int bmax) {
        try {
            this.sendHeader((short)3, 13);
            this.os.writeByte(1);
            this.os.writeShort((short)rmin);
            this.os.writeShort((short)rmax);
            this.os.writeShort((short)gmin);
            this.os.writeShort((short)gmax);
            this.os.writeShort((short)bmin);
            this.os.writeShort((short)bmax);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Blobfinder] : Couldn't send PLAYER_BLOBFINDER_SET_COLOR_REQ command: " + e.toString());
        }
    }

    public void setImagerParams(int brightness, int contrast, int colormode, int autogain) {
        try {
            this.sendHeader((short)3, 7);
            this.os.writeByte(2);
            this.os.writeShort((short)brightness);
            this.os.writeShort((short)contrast);
            this.os.writeByte((byte)colormode);
            this.os.writeByte((byte)autogain);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Blobfinder] : Couldn't  send PLAYER_BLOBFINDER_SET_IMAGER_PARAMS_REQ command: " + e.toString());
        }
    }

    public synchronized short getImageWidth() {
        return this.imageWidth;
    }

    public synchronized short getImageHeight() {
        return this.imageHeight;
    }

    public synchronized short getBlobCount() {
        return this.blobCount;
    }

    public synchronized Blob[] getBlobs() {
        return this.blobList;
    }

    public synchronized Blob getBlob(int i) {
        return this.blobList[i];
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[Blobfinder][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    System.err.println("[Blobfinder] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Blobfinder] : Error when reading payload " + e.toString());
        }
    }
}

