/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class AudioMixerInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_AUDIOMIXER_CODE = (short)29;
    private static final short PLAYER_MSGTYPE_CMD = 2;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    protected static final short PLAYER_AUDIOMIXER_SET_MASTER = 1;
    protected static final short PLAYER_AUDIOMIXER_SET_PCM = 2;
    protected static final short PLAYER_AUDIOMIXER_SET_LINE = 3;
    protected static final short PLAYER_AUDIOMIXER_SET_MIC = 4;
    protected static final short PLAYER_AUDIOMIXER_SET_IGAIN = 5;
    protected static final short PLAYER_AUDIOMIXER_SET_OGAIN = 6;
    private int masterLeft;
    private int masterRight;
    private int pcmLeft;
    private int pcmRight;
    private int lineLeft;
    private int lineRight;
    private int micLeft;
    private int micRight;
    private int iGain;
    private int oGain;

    public AudioMixerInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)29;
        this.index = indexOfDevice;
    }

    public void setVolume(byte subtype, short left, short right) {
        try {
            this.sendHeader((short)2, 5);
            this.os.writeByte(subtype);
            this.os.writeShort(left);
            this.os.writeShort(right);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[AudioMixer] : Couldn't send new command: " + e.toString());
        }
    }

    public void getLevels(byte subtype) {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(subtype);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[AudioMixer] : Couldn't send command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[AudioMixer][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                default: 
            }
            this.masterLeft = this.is.readUnsignedShort();
            this.masterRight = this.is.readUnsignedShort();
            this.pcmLeft = this.is.readUnsignedShort();
            this.pcmRight = this.is.readUnsignedShort();
            this.lineLeft = this.is.readUnsignedShort();
            this.lineRight = this.is.readUnsignedShort();
            this.micLeft = this.is.readUnsignedShort();
            this.micRight = this.is.readUnsignedShort();
            this.iGain = this.is.readUnsignedShort();
            this.oGain = this.is.readUnsignedShort();
        }
        catch (Exception e) {
            System.err.println("[AudioMixer] : Error when reading payload " + e.toString());
        }
    }

    public synchronized int getMasterLeft() {
        return this.masterLeft;
    }

    public synchronized int getMasterRight() {
        return this.masterRight;
    }

    public synchronized int getPCMLeft() {
        return this.pcmLeft;
    }

    public synchronized int getPCMRight() {
        return this.pcmLeft;
    }

    public synchronized int getLineLeft() {
        return this.lineLeft;
    }

    public synchronized int getLineRight() {
        return this.lineLeft;
    }

    public synchronized int getMicLeft() {
        return this.micLeft;
    }

    public synchronized int getMicRight() {
        return this.micLeft;
    }

    public synchronized int getIGain() {
        return this.iGain;
    }

    public synchronized int getOGain() {
        return this.oGain;
    }
}

