/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class AudioInterface
extends PlayerDevice {
    private final short PLAYER_AUDIO_CODE = (short)9;
    private final short PLAYER_MSGTYPE_CMD = (short)2;
    private int[] frequency = new int[5];
    private int[] amplitude = new int[5];

    public AudioInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)9;
        this.index = indexOfDevice;
        for (int i = 0; i < 5; ++i) {
            this.frequency[i] = 0;
            this.amplitude[i] = 0;
        }
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            for (int i = 0; i < 5; ++i) {
                this.frequency[i] = this.is.readUnsignedShort();
                this.amplitude[i] = this.is.readUnsignedShort();
            }
        }
        catch (Exception e) {
            System.err.println("[Audio] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int[] getFiveHighestFrequencies() {
        return this.frequency;
    }

    public synchronized int[] getFiveHighestAmplitudes() {
        return this.amplitude;
    }

    public void produceSound(short freq, short amp, short duration) {
        try {
            this.sendHeader((short)2, 6);
            this.os.writeShort(freq);
            this.os.writeShort(amp);
            this.os.writeShort(duration);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[Audio] : Couldn't send produce sound command request: " + e.toString());
        }
    }
}

