/*
 * Decompiled with CFR 0.152.
 */
package javaclient;

import javaclient.PlayerClient;
import javaclient.PlayerDevice;

public class AudioDSPInterface
extends PlayerDevice {
    private static final boolean isDebugging = PlayerClient.isDebugging;
    private final short PLAYER_AUDIODSP_CODE = (short)28;
    private static final short PLAYER_MSGTYPE_CMD = 2;
    private static final short PLAYER_MSGTYPE_REQ = 3;
    private static final short PLAYER_MAX_DEVICE_STRING_LEN = 64;
    public static final short PLAYER_AUDIODSP_SET_CONFIG = 1;
    public static final short PLAYER_AUDIODSP_GET_CONFIG = 2;
    public static final short PLAYER_AUDIODSP_PLAY_TONE = 3;
    public static final short PLAYER_AUDIODSP_PLAY_CHIRP = 4;
    public static final short PLAYER_AUDIODSP_REPLAY = 5;
    private int[] frequency = new int[5];
    private int[] amplitude = new int[5];
    private int sampleFormat;
    private int sampleRate;
    private byte channels;

    public AudioDSPInterface(PlayerClient pc, short indexOfDevice) {
        super(pc);
        this.device = (short)28;
        this.index = indexOfDevice;
    }

    public synchronized void readData() {
        this.readHeader();
        try {
            int i;
            for (i = 0; i < 5; ++i) {
                this.frequency[i] = this.is.readUnsignedShort();
            }
            for (i = 0; i < 5; ++i) {
                this.amplitude[i] = this.is.readUnsignedShort();
            }
        }
        catch (Exception e) {
            System.err.println("[AudioDSP] : Error when reading payload: " + e.toString());
        }
    }

    public synchronized int[] getFrequencies() {
        return this.frequency;
    }

    public synchronized int[] getAmplitudes() {
        return this.amplitude;
    }

    public void command(byte subtype, int freq, int amp, int duration, char[] bitString, int bitStringLen) {
        try {
            int size = 84;
            this.sendHeader((short)2, size);
            this.os.writeInt(subtype);
            this.os.writeInt(freq);
            this.os.writeInt(amp);
            this.os.writeInt(duration);
            for (int i = 0; i < 64; ++i) {
                this.os.writeChar(bitString[i]);
            }
            this.os.writeInt(bitStringLen);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[AudioDSP] : Couldn't send new command: " + e.toString());
        }
    }

    public void getAudioProperties() {
        try {
            this.sendHeader((short)3, 1);
            this.os.writeByte(2);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[AudioDSP] : Couldn't send PLAYER_AUDIODSP_GET_CONFIG command: " + e.toString());
        }
    }

    public void setAudioProperties(int sampleFormat, int sampleRate, byte channels) {
        try {
            this.sendHeader((short)3, 8);
            this.os.writeByte(1);
            this.os.writeInt(sampleFormat);
            this.os.writeShort(sampleRate);
            this.os.writeByte(channels);
            this.os.flush();
        }
        catch (Exception e) {
            System.err.println("[AudioDSP] : Couldn't send PLAYER_AUDIODSP_SET_CONFIG command: " + e.toString());
        }
    }

    public void handleResponse(int size) {
        if (size == 0) {
            if (isDebugging) {
                System.err.println("[AudioDSP][Debug] : Unexpected response of size 0!");
            }
            return;
        }
        try {
            byte subtype = this.is.readByte();
            switch (subtype) {
                case 2: {
                    this.sampleFormat = this.is.readInt();
                    this.sampleRate = this.is.readUnsignedShort();
                    this.channels = (byte)this.is.readUnsignedByte();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    System.err.println("[AudioDSP] : Unexpected response " + subtype + " of size = " + size);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[AudioDSP] : Error when reading payload " + e.toString());
        }
    }

    public synchronized int getSampleFormat() {
        return this.sampleFormat;
    }

    public synchronized int getSampleRate() {
        return this.sampleRate;
    }

    public synchronized byte getChannels() {
        return this.channels;
    }
}

